/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.mask.Main;
import com.sun.javacard.jcasm.mask.TableManager;
import com.sun.javacard.jcasm.mask.TargetReference;

class SubRef {
    TargetReference[] tr = new TargetReference[128];
    int[] objectReferences = new int[128];
    int location;
    int GRT_SUBREF_ENTRY_SIZE = 3;
    int availableSlot = 0;

    SubRef() {
    }

    int addTargetReference(int refAddr, int pkgId) {
        int targetRef = this.availableSlot;
        this.tr[this.availableSlot] = new TargetReference(refAddr, pkgId);
        ++this.availableSlot;
        if (this.availableSlot == 128) {
            this.availableSlot = -1;
        }
        return targetRef;
    }

    int addObjectLevel1(int objectAddr) {
        int targetRef = this.availableSlot;
        this.objectReferences[this.availableSlot] = objectAddr;
        ++this.availableSlot;
        if (this.availableSlot == 128) {
            this.availableSlot = -1;
        }
        return targetRef + 1;
    }

    int addGRTToMask(StringBuffer buffer, int memLoc, int tableNumber) {
        this.location = memLoc;
        String emptyEntryFiller = "0x00, 0x00, 0x00, ";
        if (Main.FLAG_32_BIT) {
            emptyEntryFiller = "0x00, 0x00, 0x00, 0x00, ";
            this.GRT_SUBREF_ENTRY_SIZE = 4;
        }
        buffer.append("/* Sub referece table Number " + tableNumber + " @" + Msg.toAddressString(this.location) + " */" + Msg.eol);
        for (int i = 0; i < 128; ++i) {
            if (this.tr[i] != null) {
                if (Main.FLAG_32_BIT) {
                    buffer.append(Msg.to24BitHexString(this.tr[i].address));
                    buffer.append(Msg.toHexString((byte)this.tr[i].pkgId) + ", ");
                } else {
                    buffer.append(Msg.to16BitHexString(this.tr[i].address));
                    buffer.append(Msg.toHexString((byte)this.tr[i].pkgId) + ", ");
                }
            } else {
                buffer.append(emptyEntryFiller);
            }
            if (i % 8 != 7) continue;
            buffer.append(Msg.eol);
        }
        return this.GRT_SUBREF_ENTRY_SIZE * 128;
    }

    int addObjectTableToMask(StringBuffer buffer, int memLoc, int tableNumber) {
        this.location = memLoc;
        buffer.append("/* Sub referece Object Table Number " + tableNumber + " @" + Msg.toAddressString(this.location) + " */" + Msg.eol);
        for (int i = 0; i < 128; ++i) {
            if (Main.FLAG_32_BIT) {
                buffer.append(Msg.to24BitHexString(this.objectReferences[i]));
            } else {
                buffer.append(Msg.to16BitHexString(this.objectReferences[i]));
            }
            if (i % 8 != 6) continue;
            buffer.append(Msg.eol);
        }
        return TableManager.REF_SIZE * 128;
    }
}

