/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.jc_tck_internal;

import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import java.io.File;
import java.io.PrintWriter;
import javasoft.sqe.jc_tck_internal.DistrTestDescription;
import javasoft.sqe.jc_tck_internal.PrecompileScript;

public class DistrPrecompileScript
extends PrecompileScript {
    public static final String CLIENT_COMPILE = "clientCompile";
    private String precompileClassDir;

    public Status run(String[] args, TestDescription td, TestEnvironment env) {
        Status stat = super.run(args, td, env);
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-precompileClassDir") || i + 1 >= args.length) continue;
            this.setPrecompileClassDir(args[++i]);
            break;
        }
        return stat.isPassed() ? this.compileClientSources(args, td, env) : stat;
    }

    public Status compileClientSources(String[] args, TestDescription td, TestEnvironment env) {
        if (td instanceof DistrTestDescription) {
            PrintWriter trOut = this.getTestResult().getTestCommentWriter();
            trOut.println("Precompiling client source files...");
            File[] srcs = ((DistrTestDescription)td).getClientSourcesFiles();
            if (srcs == null || srcs.length == 0) {
                return Status.passed((String)"");
            }
            boolean allJavaSrc = true;
            for (int i = 0; i < srcs.length && allJavaSrc; ++i) {
                String srcPath = srcs[i].getPath();
                allJavaSrc = srcPath.endsWith(".java");
            }
            Status compileStatus = !allJavaSrc ? this.compileIndividually(CLIENT_COMPILE, srcs) : (this.precompileClassDir != null ? this.compileIfNecessary(CLIENT_COMPILE, srcs, this.precompileClassDir) : this.compileTogether(CLIENT_COMPILE, srcs));
            if (!compileStatus.isPassed()) {
                return error_compFailUnexp.augment(compileStatus);
            }
            return compileStatus;
        }
        return Status.passed((String)"");
    }

    public void setPrecompileClassDir(String d) {
        this.precompileClassDir = d;
        super.setPrecompileClassDir(d);
    }
}

