/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tgxml.tools.testgen;

import com.sun.tgxml.tjtf.tools.ToolBase;
import com.sun.tgxml.tjtf.tools.options.Option;
import com.sun.tgxml.tjtf.tools.options.ParseArgumentException;
import com.sun.tgxml.tjtf.tools.options.StringOption;
import com.sun.tgxml.tools.testgen.TestGenFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Vector;

public class BundleTestGenFilter
extends ToolBase {
    private static final String CtStr_ToolName = "BundleTestGenFilter";
    int cur_num = 0;
    String baseDir;
    String plugin;
    String exList;
    String libListOut;
    String outDir;
    String dirList;
    String el;
    String libListOutDir;
    String libListOutSuffix;
    String elSuffix;
    String elDir;
    String copyrightLink = null;
    protected StringOption baseDirOption = new StringOption("-basedir", "  -basedir <basedir>  the base directory relatively to which the directories in -dirList are specified", true);
    protected StringOption pluginOption = new StringOption("-plugin", "  -plugin <plugin_class>  the class of test filter plugin (obligatory)", true);
    protected StringOption exListOption = new StringOption("-exlist", "  -exlist <exclude_list> initial tck.jtx exclude list", true);
    protected StringOption libListOutOption = new StringOption("-liblistOut", "  -liblistOut <dir/libID.lst>  dirname of <dir/libID.lst> is used to store all created tests-on-libraries libID.lst dependencies to, basename is used as suffix for all stored dependencies files", true);
    protected StringOption outDirOption = new StringOption("-outDir", "  -outDir <outDir> base directory to store generated files to: <JCK_dir>", true);
    protected StringOption elOption = new StringOption("-el", "  -el <dir/jdk.jtx>  dirname of <dir/jdk.jtx> is used to store all created jdk.jtx-es to, basename is used as suffix for all stored jtx files", true);
    protected StringOption dirListOption = new StringOption("-dirList", "  -dirList <dirList>  file with the bundle's list of directories for which to run TestGenFilter", true);
    protected StringOption copyrightLinkOption = new StringOption("-copyrightLink", "  -copyrightLink <pathToCopyrightFile>  the path (relative) to copyright file (optional)");

    public void registerOptions() {
        this.addOption((Option)this.baseDirOption);
        this.addOption((Option)this.pluginOption);
        this.addOption((Option)this.exListOption);
        this.addOption((Option)this.libListOutOption);
        this.addOption((Option)this.outDirOption);
        this.addOption((Option)this.elOption);
        this.addOption((Option)this.dirListOption);
        this.addOption((Option)this.copyrightLinkOption);
    }

    public void applyOptionsValues() throws ParseArgumentException {
        this.baseDir = this.baseDirOption.getStringValue();
        if (!new File(this.baseDir).isDirectory()) {
            throw new ParseArgumentException("Wrong 'basedir' directory: " + this.baseDir);
        }
        this.plugin = this.pluginOption.getStringValue();
        this.exList = this.exListOption.getStringValue();
        this.libListOut = this.libListOutOption.getStringValue();
        this.libListOutDir = new File(this.libListOut).getParent();
        if (this.libListOutDir == null || this.libListOutDir.equals("")) {
            this.libListOutDir = ".";
        }
        this.libListOutSuffix = new File(this.libListOut).getName();
        if (!new File(this.libListOutDir).isDirectory()) {
            throw new ParseArgumentException("Directory " + this.libListOutDir + " is not a directory or does not exist");
        }
        this.libListOutDir = new File(this.libListOutDir).getAbsolutePath();
        this.outDir = this.outDirOption.getStringValue();
        if (!new File(this.outDir).isDirectory()) {
            throw new ParseArgumentException("Wrong 'outDir' directory: " + this.outDir);
        }
        this.outDir = new File(this.outDir).getAbsolutePath();
        this.el = this.elOption.getStringValue();
        this.elDir = new File(this.el).getParent();
        if (this.elDir == null || this.elDir.equals("")) {
            this.elDir = ".";
        }
        this.elSuffix = new File(this.el).getName();
        if (!new File(this.elDir).isDirectory()) {
            throw new ParseArgumentException("Directory " + this.elDir + " is not a directory or does not exist");
        }
        this.elDir = new File(this.elDir).getAbsolutePath();
        this.dirList = this.dirListOption.getStringValue();
        if (!new File(this.dirList).isFile()) {
            throw new ParseArgumentException("Wrong 'dirList' file: " + this.dirList);
        }
        if (this.copyrightLinkOption.isSet()) {
            this.copyrightLink = this.copyrightLinkOption.getStringValue();
        }
    }

    public static void main(String[] args) {
        BundleTestGenFilter bundletestgenfilter = new BundleTestGenFilter(System.out, System.err);
        bundletestgenfilter.setProgramName(CtStr_ToolName);
        System.exit(bundletestgenfilter.run(args));
    }

    public BundleTestGenFilter(PrintStream out, PrintStream err) {
        super(out, err);
        this.m_needsCommandLineArguments = true;
    }

    public void startTool() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(new File(this.dirList)));
            boolean isAbsolute = false;
            int i = 0;
            String dname = reader.readLine();
            while (dname != null) {
                String inDir;
                String[] complete_args;
                if (++i == 1) {
                    isAbsolute = dname.startsWith(this.baseDir);
                }
                String dirPath = isAbsolute ? dname.substring(this.baseDir.length()) : dname;
                int uniqID = this.getUniqID();
                Vector<String> args = new Vector<String>();
                args.add("-plugin");
                args.add(this.plugin);
                args.add("-exlist");
                args.add(this.exList);
                args.add("-liblistOut");
                args.add(this.libListOutDir + File.separator + uniqID + this.libListOutSuffix);
                args.add("-o");
                args.add(this.outDir + File.separator + dirPath);
                args.add("-el");
                args.add(this.elDir + File.separator + uniqID + this.elSuffix);
                if (this.copyrightLink != null) {
                    String finalToOutRelativePath = this.getRelativePath((String)args.get(7), this.outDir);
                    if (finalToOutRelativePath == null) {
                        this.reportErrorMsg("outDir: " + this.outDir + " is not a subdirectory of final test dir: " + (String)args.get(7));
                        this.setResultCode(1);
                        break;
                    }
                    String copyrightPath = finalToOutRelativePath.equals("") ? this.copyrightLink : finalToOutRelativePath + File.separator + this.copyrightLink;
                    args.add("-emitter.copyrightLink=" + copyrightPath);
                }
                if ((complete_args = this.addOperands(args, inDir = this.baseDir + File.separator + dirPath)) != null) {
                    this.reportOutputMsg("\n...running TestGenFilter " + this.getString(complete_args));
                    int res = new TestGenFilter(this.getStandardOut(), this.getStandardErr()).run(complete_args);
                    if (res != 0) {
                        this.reportErrorMsg("Error occured running the last TestGenFilter iteration.");
                        this.setResultCode(1);
                        break;
                    }
                } else {
                    this.reportOutputMsg("\n...running TestGenFilter " + this.getString(args.toArray(new String[0])));
                    this.reportOutputMsg("\n no .test.xml or .doc.xml files in " + inDir);
                }
                dname = reader.readLine();
            }
        }
        catch (Exception e) {
            this.reportErrorMsg(e.getMessage());
            this.setResultCode(1);
        }
    }

    protected String getRelativePath(String fullPath, String parentPath) {
        if (fullPath.equals(parentPath)) {
            return "";
        }
        if (!fullPath.startsWith(parentPath)) {
            return null;
        }
        String p = "..";
        while ((fullPath = new File(fullPath).getParent()) != null && !fullPath.equals(parentPath)) {
            p = p + File.separator + "..";
        }
        if (fullPath == null) {
            return "";
        }
        return p;
    }

    protected String getString(String[] str_arr) {
        String str = "";
        for (int i = 0; i < str_arr.length; ++i) {
            str = str + " " + str_arr[i];
        }
        return str;
    }

    protected String[] addOperands(Vector predefinedArgs, String inDir) {
        int i;
        File[] filesInDir = new File(inDir).listFiles();
        if (filesInDir == null || filesInDir.length == 0) {
            return null;
        }
        Vector<String> xml_files = new Vector<String>();
        for (i = 0; i < filesInDir.length; ++i) {
            String fileName = filesInDir[i].getName();
            if (!fileName.endsWith(".tdoc.xml") && !fileName.endsWith(".test.xml")) continue;
            xml_files.add(filesInDir[i].getAbsolutePath());
        }
        if (xml_files.size() == 0) {
            return null;
        }
        for (i = 0; i < xml_files.size(); ++i) {
            predefinedArgs.add(xml_files.get(i));
        }
        return predefinedArgs.toArray(new String[0]);
    }

    protected int getUniqID() {
        return ++this.cur_num;
    }
}

