/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.me.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class User {
    public static final String YES = "yes";
    public static final String YES_SHORT = "y";
    public static final String NO = "no";
    public static final String NO_SHORT = "n";
    public static final UserConfirmation NOT_INTERACTIVE = new UserConfirmation(){

        public void log(String message) {
            System.out.println(message);
        }

        public String ask(String message) {
            return User.YES;
        }
    };
    public static final UserConfirmation INTERACTIVE = new UserConfirmation(){
        private BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

        public void log(String message) {
            System.out.println(message);
        }

        public String ask(String message) {
            this.log(message);
            try {
                return this.in.readLine();
            }
            catch (IOException ex) {
                return "Exception:" + ex;
            }
        }
    };
    private UserConfirmation impl;

    public void log(Throwable e) {
        e.printStackTrace();
    }

    public static UserConfirmation createNotInteractiveUser(final PrintWriter out) {
        return new UserConfirmation(){

            public void log(String message) {
                out.println(message);
                out.flush();
            }

            public String ask(String message) {
                this.log(message);
                return User.YES;
            }
        };
    }

    public void log(String message) {
        this.impl.log(message);
    }

    public User(UserConfirmation impl) {
        this.impl = impl;
    }

    public void checkYes(String question) {
        String answer = this.impl.ask(question);
        if (!User.isYesResponse(answer)) {
            throw new IllegalArgumentException("Interrupted:" + answer);
        }
    }

    public boolean isYes(String question) {
        String answer = this.impl.ask(question);
        return User.isYesResponse(answer);
    }

    public static boolean isYesResponse(String answer) {
        return answer != null && (answer.equalsIgnoreCase(YES) || answer.equalsIgnoreCase(YES_SHORT) || answer.equalsIgnoreCase("true")) || answer.equalsIgnoreCase("");
    }

    public static interface UserConfirmation {
        public void log(String var1);

        public String ask(String var1);
    }
}

