/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.me.utils;

import com.sun.tck.me.utils.Converter;
import com.sun.tck.me.utils.Converters;
import com.sun.tck.me.utils.MethodDescriptor;
import com.sun.tck.me.utils.SingleArgumentConverter;
import com.sun.tck.me.utils.User;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class CommandLine {
    private User user = new User(User.INTERACTIVE);
    private Map<String, Converter> converters = Converters.createConverters();
    private Map<String, MethodDescriptor> methods = new HashMap<String, MethodDescriptor>();
    private boolean isBatch;
    private String[] args;

    public CommandLine(Object ... list) {
        this.converters = Converters.createConverters();
        this.setBatch(true);
        this.converters.put(String[].class.getName(), new SingleArgumentConverter(){

            public Object convertElement(String value) throws Exception {
                return value == null ? null : value.trim().split("[ \n\t]+");
            }
        });
        this.methods = new HashMap<String, MethodDescriptor>();
        for (Object current : list) {
            for (Method meth : current.getClass().getMethods()) {
                Class<?>[] params = meth.getParameterTypes();
                Converter converter = null;
                if (params.length > 1 || params.length == 1 && (converter = this.converters.get(params[0].getName())) == null) continue;
                String name = meth.getName();
                MethodDescriptor descr = this.methods.get(name);
                if (descr != null) {
                    descr.invalidate();
                    continue;
                }
                descr = new MethodDescriptor(current, meth, converter);
                this.methods.put(name, descr);
            }
        }
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public void setBatch(boolean isBatch) {
        this.isBatch = isBatch;
        if (isBatch) {
            this.setUser(User.NOT_INTERACTIVE);
        }
    }

    public void setArguments(String[] args) {
        this.args = args;
    }

    public void setUser(User.UserConfirmation user) {
        this.user = new User(user);
    }

    public boolean processLine(String line) {
        String args;
        String cmd;
        int pos = (line = line.trim()).indexOf(32);
        if (pos < 0) {
            cmd = line;
            args = null;
        } else {
            cmd = line.substring(0, pos);
            args = line.substring(pos + 1);
        }
        try {
            Object val = this.execute(cmd, args);
            if (val != null) {
                this.user.log(">> " + val);
            }
            return true;
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            this.user.log(t);
            return this.user.isYes("Continue?");
        }
    }

    public Object execute(String name, String args) throws Exception {
        MethodDescriptor desr = this.methods.get(name = name.replace('-', '_'));
        if (desr == null || !desr.isValid()) {
            throw new IllegalArgumentException("Unknown command:" + name);
        }
        desr.clear();
        desr.addValue(args);
        return desr.invoke();
    }

    private static String joint(String[] args) {
        StringBuffer retVal = new StringBuffer();
        String delim = "";
        for (String arg : args) {
            retVal.append(delim).append(arg);
            delim = " ";
        }
        return retVal.toString();
    }

    public void run() throws Exception {
        String line;
        if (this.isBatch) {
            this.processLine(CommandLine.joint(this.args));
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("# ");
        while ((line = in.readLine()) != null) {
            if (line.equals("")) {
                System.out.print("# ");
                continue;
            }
            if (line.indexOf("<<") >= 0) {
                return;
            }
            if (!this.processLine(line)) {
                return;
            }
            System.out.print("# ");
        }
    }
}

