/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.me.utils;

import com.sun.tck.me.utils.Closable;
import com.sun.tck.me.utils.Utils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;

public class Closables
implements Closable {
    private final ArrayList<Closable> list = new ArrayList();
    private boolean directOrder = false;

    public Closables() {
    }

    public void setDirectOrder(boolean order) {
        this.directOrder = order;
    }

    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(PrintWriter log) {
        ArrayList<Closable> actions = new ArrayList<Closable>();
        ArrayList<Closable> arrayList = this.list;
        synchronized (arrayList) {
            actions.addAll(this.list);
            this.list.clear();
        }
        if (!this.directOrder) {
            Collections.reverse(actions);
        }
        for (Closable action : actions) {
            try {
                action.close();
            }
            catch (Exception e) {
                if (log == null) continue;
                log.println("While closing Closables");
                e.printStackTrace(log);
            }
        }
    }

    public Closables(Closable[] list) {
        Utils.addArrayToCollection(this.list, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Closable element) {
        ArrayList<Closable> arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(element);
        }
    }

    public Socket add(Socket socket) {
        this.add(Closables.get(socket));
        return socket;
    }

    public ServerSocket add(ServerSocket socket) {
        this.add(Closables.get(socket));
        return socket;
    }

    public InputStream add(InputStream in) {
        this.add(Closables.get(in));
        return in;
    }

    public OutputStream add(OutputStream out) {
        this.add(Closables.get(out));
        return out;
    }

    public Reader add(final Reader reader) {
        this.add(new Closable(){

            public void close() throws Exception {
                reader.close();
            }
        });
        return reader;
    }

    public Writer add(final Writer writer) {
        this.add(new Closable(){

            public void close() throws Exception {
                writer.close();
            }
        });
        return writer;
    }

    public static Closable get(final Socket socket) {
        return new Closable(){

            public void close() throws Exception {
                socket.close();
            }
        };
    }

    public static Closable get(final ServerSocket socket) {
        return new Closable(){

            public void close() throws Exception {
                socket.close();
            }
        };
    }

    public static Closable get(final InputStream in) {
        return new Closable(){

            public void close() throws Exception {
                in.close();
            }
        };
    }

    public static Closable get(final OutputStream out) {
        return new Closable(){

            public void close() throws Exception {
                out.close();
            }
        };
    }

    public static Closable getRestore(final SecurityManager manager) {
        return new Closable(){

            public void close() throws Exception {
                System.setSecurityManager(manager);
            }
        };
    }
}

