/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.me.tools.fs;

import com.sun.tck.me.tools.fs.FileSystem;
import com.sun.tck.me.utils.Closables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DirFileSystem
implements FileSystem {
    private Closables manager = new Closables();
    private File root;
    private File pwd;
    private static final String[] EMPTY = new String[0];

    public DirFileSystem(File root) {
        this.root = root;
        this.pwd = root;
    }

    public InputStream openToRead(String path) throws IOException {
        return this.manager.add(new FileInputStream(this.createFile(path, false)));
    }

    private File createFile(String path, boolean createParent) {
        int pos = 0;
        while (path.charAt(pos) != '/') {
            ++pos;
        }
        path = path.substring(pos).replace('/', File.separatorChar);
        File file = new File(pos > 0 ? this.root : this.pwd, path);
        if (createParent) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    public OutputStream openToWrite(String path) throws IOException {
        return this.manager.add(new FileOutputStream(this.createFile(path, true)));
    }

    public FileSystem.FileType getType(String path) {
        File file = this.createFile(path, false);
        if (file.isDirectory()) {
            return FileSystem.FileType.DIR;
        }
        if (file.isFile()) {
            return FileSystem.FileType.FILE;
        }
        if (!file.exists()) {
            return FileSystem.FileType.DOES_NOT_EXIST;
        }
        return FileSystem.FileType.UNKNOWN;
    }

    public String[] list(final String path, final FileSystem.Filter fs) {
        File dir = this.createFile(path, false);
        final DirFileSystem current = this;
        String[] retVal = fs == null ? dir.list() : dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return fs.accept(current, path + "/" + name);
            }
        });
        return retVal == null ? EMPTY : retVal;
    }

    public void close() throws IOException {
        this.manager.close();
    }

    public void switchTo(String path) {
        this.pwd = new File(this.root, path.replace('/', File.separatorChar));
    }
}

