/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.javatest.cmdui;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.CardServicesPool;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import com.sun.tck.jc.javatest.services.BVTDiscoveryUtils;
import com.sun.tck.jc.javatest.ui.CancelRunException;
import com.sun.tck.jc.javatest.ui.UserInteraction;
import java.util.Set;
import javax.smartcardio.CardException;

public class CmdUserInteraction
implements UserInteraction {
    private static CmdUserInteraction instance = new CmdUserInteraction();

    private CmdUserInteraction() {
    }

    public static CmdUserInteraction getUserInteraction() {
        return instance;
    }

    public StatefulCardTerminal askForCardInsertion(String terminalLabel, boolean replacement) throws CancelRunException {
        System.out.println(I18n.getString("insert.card.message", terminalLabel));
        for (StatefulCardTerminal terminal : CardServicesPool.getAvailableTerminals()) {
            if (terminal.getLabel() != null) continue;
            try {
                terminal.waitForCardPresent(0L);
            }
            catch (CardException ex) {
                return null;
            }
            terminal.setLabel(terminalLabel);
            return terminal;
        }
        return null;
    }

    public boolean askForCardReplacement(StatefulCardTerminal terminal) throws CancelRunException {
        String terminalLabel = terminal.getLabel();
        if (terminal.checkCardPresent()) {
            System.out.println(I18n.getString("remove.card.message", terminalLabel));
        }
        try {
            terminal.waitForCardAbsent(0L);
        }
        catch (CardException ex) {
            return false;
        }
        terminal.setLabel(null);
        StatefulCardTerminal insertionTerminal = this.askForCardInsertion(terminalLabel, true);
        return insertionTerminal != null;
    }

    public String showCardIDSelectDialog(String terminalLabel) throws CancelRunException {
        Set<String> idList = BVTDiscoveryUtils.getCardStore().getCardIDs();
        if (idList == null) {
            return "0000";
        }
        return idList.toArray(new String[idList.size()])[0];
    }

    public boolean askForRetryAfterFailedConnection(String terminalLabel) {
        System.out.println(I18n.getString("card.connect.failed", terminalLabel));
        return false;
    }

    public boolean askForCardsRemoval() {
        return true;
    }
}

