/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.interview;

import com.sun.interview.DirectoryFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.tck.jc.interview.lib.ChoiceQuestion;
import com.sun.tck.jc.interview.lib.CompositeInterview;
import com.sun.tck.jc.interview.lib.FileQuestion;
import com.sun.tck.jc.interview.lib.IntQuestion;
import com.sun.tck.jc.interview.lib.PathQuestion;
import com.sun.tck.jc.interview.lib.StringQuestion;
import com.sun.tck.jc.interview.lib.Validator;
import com.sun.tck.jc.interview.lib.YesNoQuestion;
import java.io.File;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class JCTCKEnvInterview
extends CompositeInterview {
    public static final String PRODUCT = "product";
    public static final String CONFIG_NAME = "configName";
    public static final String DESCRIPTION = "description";
    public static final String BUNDLE_SIZE = "bundle_size";
    public static final String IS_RI_OR_TESTED = "isRIorTested";
    public static final String JC_HOME = "JC_HOME";
    public static final String JC_RI_HOME = "JC_RI_HOME";
    public static final String INT_SUPPORT = "int_support";
    public static final String JAVACARDX_CRYPTO_SUPPORT = "javacardx_crypto_support";
    public static final String JAVA_HOME = "java_home";
    public static final String SYSTEM_ENV = "system_env";
    public static final String JAVA_PARAM = "java_param";
    public static final String CARD_SERVICE_CLASS = "CardServiceClass";
    public static final String CARD_PROXY_OPTIONS = "CardProxyOptions";
    public static final String SERVICE_PATH = "ServicePath";
    public static final String EXPORT_PATH = "ExportPath";
    public static final String CLA_BYTE = "CLA_BYTE";
    public static final String DELETE_PACKAGE_AND_INSTANCES_SUPPORT = "deletePackageAndInstancesSupport";
    public static final String CARD_STORE_FILE = "CardStoreFile";
    public static final String Install = "install";
    public static final String Convert = "convert";
    public static final String LoadCap = "loadcapfiles";
    public static final String LoadClass = "loadclassfiles";
    private StringQuestion configNameQuestion;
    private String root;
    private ResourceBundle i18nBundle;
    private FileFilter[] allFilters;
    private Validator.FileListValidator fileListValidator;
    private Validator.VariableListValidator variableListValidator;
    public static final String REF_CARD_SERVICE_CLASS = "com.sun.javacard.referenceimpl.CJCRECardService";
    public static final String REF_CARD_SERVICE_PATH = "$JC_RI_HOME$/lib$/apduio.jar$:$JC_RI_HOME$/lib$/apdutool.jar$:$JC_RI_HOME$/lib$/api.jar$:$JC_RI_HOME$/lib$/converter.jar$:$JC_RI_HOME$/lib$/scriptgen.jar$:$JC_RI_HOME$/lib$/offcardverifier.jar$:$JCTCK_HOME$/lib$/jctck-referenceimpl.jar";

    public JCTCKEnvInterview(Interview parent, String tag) {
        super(parent, tag);
        this.root = this.root;
        this.i18nBundle = this.getResourceBundle();
        this.allFilters = this.initFileFilter();
        this.fileListValidator = new Validator.FileListValidator(this, "FileNotFound");
        this.variableListValidator = new Validator.VariableListValidator(this, "incorrect_system_variable_list");
        this.configNameQuestion = new StringQuestion(this, CONFIG_NAME, Validator.ConfigName, this.values, new String[]{this.i18n("product.JC_TCK"), this.i18n("product.JavaCard_TCK")});
        this.addQuestion((Question)this.configNameQuestion, CONFIG_NAME);
        this.addQuestion((Question)new StringQuestion(this, DESCRIPTION, Validator.NotEmpty, this.values, new String[]{this.i18n("description.complete_tck"), this.i18n("description.api")}), DESCRIPTION);
        this.setProductQuestions();
        this.setJavaQuestions();
        this.setCardServiceQuestions();
        this.addQuestion((Question)new IntQuestion(this, BUNDLE_SIZE, 0, 128, Validator.TrueValidator, this.values), BUNDLE_SIZE, "0");
    }

    protected FileFilter[] initFileFilter() {
        return new FileFilter[]{new FileFilter(){

            public boolean accept(File f) {
                String name = f.getName().toLowerCase();
                return name.endsWith(".jar") || name.endsWith(".zip");
            }

            public boolean acceptsDirectories() {
                return false;
            }

            public String getDescription() {
                return JCTCKEnvInterview.this.i18n("file.filter.zip_files");
            }
        }, new FileFilter(){

            public boolean accept(File f) {
                return true;
            }

            public boolean acceptsDirectories() {
                return true;
            }

            public String getDescription() {
                return JCTCKEnvInterview.this.i18n("file.filter.all");
            }
        }};
    }

    protected void setProductQuestions() {
        this.addQuestion((Question)new ChoiceQuestion(this, PRODUCT, new String[]{Install, Convert, LoadCap, LoadClass}, new String[]{this.i18n(Install), this.i18n(Convert), this.i18n(LoadCap), this.i18n(LoadClass)}, Validator.NotEmpty, this.values), PRODUCT);
        FileQuestion impl_root = new FileQuestion(this, JC_HOME, JCTCKEnvInterview.or(Validator.isDirectoryValidator, Validator.Empty), this.values);
        impl_root.setFilter((FileFilter)new DirectoryFileFilter(this.i18n("file.filter.directories")));
        this.addQuestion((Question)impl_root, JC_HOME);
        FileQuestion ri_root = new FileQuestion(this, JC_RI_HOME, Validator.isDirectoryValidator, this.values);
        ri_root.setFilter((FileFilter)new DirectoryFileFilter(this.i18n("file.filter.directories")));
        this.addQuestion((Question)ri_root, JC_RI_HOME);
        this.addQuestion((Question)new YesNoQuestion(this, INT_SUPPORT, Validator.NotEmpty, this.values), null, "Yes");
        this.addQuestion((Question)new YesNoQuestion(this, JAVACARDX_CRYPTO_SUPPORT, Validator.NotEmpty, this.values), null, "Yes");
        this.addQuestion((Question)new YesNoQuestion(this, DELETE_PACKAGE_AND_INSTANCES_SUPPORT, Validator.NotEmpty, this.values), null, "Yes");
        this.addQuestion((Question)new ChoiceQuestion(this, CLA_BYTE, new String[]{"0", "128", "144", "160"}, new String[]{"0x0X  ", "0x8X  ", "0x9X  ", "0xAX  "}, Validator.NotEmpty, this.values), CLA_BYTE, "0");
    }

    protected void setJavaQuestions() {
        FileQuestion java_home = new FileQuestion(this, JAVA_HOME, Validator.isDirectoryValidator, this.values);
        java_home.setFilter((FileFilter)new DirectoryFileFilter(this.i18n("file.filter.directories")));
        this.addQuestion((Question)java_home, "JAVA_HOME", System.getProperty("java.home"));
        this.addQuestion((Question)new StringQuestion(this, SYSTEM_ENV, this.variableListValidator, this.values), SYSTEM_ENV, File.separatorChar == '\\' ? "SystemRoot=C:$/WINNT" : null);
        this.addQuestion((Question)new StringQuestion(this, JAVA_PARAM, Validator.TrueValidator, this.values), JAVA_PARAM);
    }

    protected void setCardServiceQuestions() {
        this.addQuestion((Question)new FileQuestion(this, CARD_STORE_FILE, Validator.NotEmpty, this.values), CARD_STORE_FILE);
        this.addQuestion((Question)new StringQuestion(this, CARD_SERVICE_CLASS, Validator.NotEmpty, this.values), CARD_SERVICE_CLASS);
        this.addQuestion((Question)new PathQuestion(this, SERVICE_PATH, this.allFilters, this.fileListValidator, this.values, JC_HOME), SERVICE_PATH);
        this.addQuestion((Question)new PathQuestion(this, EXPORT_PATH, this.allFilters, this.fileListValidator, this.values, JC_HOME), EXPORT_PATH);
        this.addQuestion((Question)new StringQuestion(this, CARD_PROXY_OPTIONS, Validator.TrueValidator, this.values), null);
    }

    public boolean isApplicable(Question current) {
        String tag = current.getTag();
        if (this.createTag(JC_RI_HOME).equals(tag) || this.createTag(EXPORT_PATH).equals(tag)) {
            return this.isModeSet(Convert);
        }
        if (this.createTag(BUNDLE_SIZE).equals(current.getTag())) {
            return this.isModeSet(Install) || this.isModeSet(LoadClass) || this.isModeSet(LoadCap);
        }
        if (this.createTag(CLA_BYTE).equals(current.getTag())) {
            return this.isModeSet(Install) || this.isModeSet(LoadClass) || this.isModeSet(LoadCap);
        }
        return true;
    }

    public boolean isModeSet(String mode) {
        return mode.equals(this.getValue(PRODUCT));
    }

    public String getName() {
        return this.configNameQuestion.getStringValue();
    }

    public void setName(String name) {
        this.configNameQuestion.setValue(name);
    }

    public String getProduct() {
        return this.getValue(PRODUCT);
    }

    public void setRoot(String root) {
        this.root = root;
    }

    private void putIfNull(String key, String value) {
        if (this.getValue(key) == null) {
            this.putValue(key, value);
        }
    }

    public static String yesToTrue(String value) {
        return "Yes".equals(value) ? "true" : "false";
    }

    public static String addCoverArg(String value, String arg) {
        if (value == null) {
            return "";
        }
        StringBuffer retVal = new StringBuffer();
        StringTokenizer e = new StringTokenizer(value, " \n\t");
        while (e.hasMoreTokens()) {
            retVal.append(arg);
            String current = e.nextToken();
            if (current.startsWith("\"")) {
                retVal.append(current);
                continue;
            }
            retVal.append(" \"");
            retVal.append(current);
            retVal.append("\" ");
        }
        return retVal.toString();
    }

    public void export(Map map) {
        map.put("JCTCK_HOME", "$testSuiteRootDir");
        map.put("JcTckClasses", "$JCTCK_HOME$/classes");
        map.put("RunCommand", "com.sun.javatest.lib.ExecStdTestOtherJVMCmd " + this.getValue(SYSTEM_ENV) + " CLASSPATH=\"$" + SERVICE_PATH + "$:$JCTCK_HOME$/lib$/javatest.jar$:$JCTCK_HOME$/classes$:" + "$JCTCK_HOME$/lib$/jctck-utils.jar\" \"$JAVA_HOME$/bin$/java\" " + this.getValue(JAVA_PARAM));
        map.put("libdir", "$JCTCK_HOME$/src$/share$/libs");
        map.put(INT_SUPPORT, JCTCKEnvInterview.yesToTrue(this.getValue(INT_SUPPORT)));
        map.put(DELETE_PACKAGE_AND_INSTANCES_SUPPORT, JCTCKEnvInterview.yesToTrue(this.getValue(DELETE_PACKAGE_AND_INSTANCES_SUPPORT)));
        map.put(JAVACARDX_CRYPTO_SUPPORT, JCTCKEnvInterview.yesToTrue(this.getValue(JAVACARDX_CRYPTO_SUPPORT)));
        map.put(CARD_PROXY_OPTIONS, JCTCKEnvInterview.addCoverArg(this.getValue(CARD_PROXY_OPTIONS), "-s"));
        String mode = this.getValue(PRODUCT);
        if (mode == null) {
            return;
        }
        if (Convert.equals(mode)) {
            map.put("ScriptArgs", "-convert -install");
            map.put("command.install", "com.sun.javatest.lib.ExecStdTestOtherJVMCmd " + this.getValue(SYSTEM_ENV) + " CLASSPATH=\"" + REF_CARD_SERVICE_PATH + "$:$JCTCK_HOME$/lib$/javatest.jar$:$JCTCK_HOME$/classes$:" + "$JCTCK_HOME$/lib$/jctck-utils.jar\" \"$JAVA_HOME$/bin$/java\" " + "com.sun.javacard.cjck.invoke.CardProxyTest " + "-s -RI -s \"$JC_RI_HOME\" -s -classpath -s \"" + REF_CARD_SERVICE_PATH + "\" -s -PC-i " + "-C " + REF_CARD_SERVICE_CLASS + " -mode install -Test $test " + "-o \"$testWorkDir\" -classdir \"$JcTckClasses\" " + "-exportdir \"$JC_RI_HOME$/api_export_files$:$JCTCK_HOME$/export_files\" " + "-bundle_size 0 -capfiledir \"$testWorkDir\" -refcapfiledir \"$test\" " + "-libdir $libdir " + "-executeClass $testExecuteClass $testExecuteArgs");
            map.put("command.convert", "$RunCommand com.sun.javacard.cjck.invoke.CardProxyTest $CardProxyOptions -C \"$CardServiceClass\" -mode convert -Test \"$test\" $InitOptions -o \"$testWorkDir\" -classdir \"$JcTckClasses\" -exportdir \"$ExportPath$:$JCTCK_HOME$/export_files\" -bundle_size 0 -capfiledir \"$testWorkDir\" -libdir $libdir  -executeClass $testExecuteClass $testExecuteArgs");
        } else {
            map.put("ScriptArgs", "-install");
            map.put("command.install", "com.sun.javacard.cjck.invoke.CardTest $CardProxyOptions -C $CardServiceClass -mode " + mode + " -Test \"$test\"" + " -o \"$testWorkDir\" -classdir \"$JcTckClasses\"" + " -exportdir \"$ExportPath$:$JCTCK_HOME$/export_files\"" + " -bundle_size $bundle_size" + " -capfiledir \"$test\"" + " -libdir $libdir" + " -get_response_cla_byte $CLA_BYTE" + " -executeClass $testExecuteClass $testExecuteArgs");
        }
        super.export(map);
    }

    private String i18n(String key) {
        if (this.i18nBundle != null) {
            try {
                return this.i18nBundle.getString(key);
            }
            catch (MissingResourceException e) {
                return key;
            }
        }
        return key;
    }
}

