/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.tlv;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class ConstantBundle {
    private Transformation parser = new Transformation();
    private HashMap<Integer, String> map = new HashMap();

    public ConstantBundle() {
        this(true, null);
    }

    public ConstantBundle(boolean addRequired, Class cl) {
        this.parser.addRequired = addRequired;
        this.registerConstants(cl);
    }

    public void setAddRequired(boolean addRequired) {
        this.parser.addRequired = addRequired;
    }

    public String find(int constant) {
        String retVal = this.map.get(new Integer(constant = this.parser.createKey(constant)));
        return retVal == null ? Integer.toHexString(constant) : retVal;
    }

    private boolean isNumber(Class type) {
        return type.equals(Integer.TYPE) || type.equals(Byte.TYPE) || type.equals(Short.TYPE);
    }

    private void registerConstants(Class cl) {
        if (cl == null) {
            return;
        }
        for (Field f : cl.getFields()) {
            int mod = f.getModifiers();
            Class<?> type = f.getType();
            if (!Modifier.isFinal(mod) || !Modifier.isStatic(mod) || !this.isNumber(type)) continue;
            try {
                this.register(f.getInt(null), f.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void register(int constant, String name) {
        this.parser.registerAllVariants(this.map, constant, name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Transformation {
        private int mask = 255;
        private boolean addRequired = true;

        public int createKey(int constant) {
            return constant & this.mask;
        }

        public void registerAllVariants(Map<Integer, String> names, int constant, String name) {
            constant = this.createKey(constant);
            String hex = Integer.toHexString(constant);
            names.put(new Integer(constant), name + "(0x" + hex + ")");
            if (this.addRequired) {
                int req = constant | 0x80;
                names.put(new Integer(req), name + "(0x" + Integer.toHexString(req) + " response-required-bit" + ")");
            }
        }
    }
}

