/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.gsm;

import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.javacard.cjck.userinterface.FatalException;
import com.sun.javacard.cjck.userinterface.OutOfMemoryOnCardException;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.tck.bvtool.etsi.data.ResponseHeader;
import com.sun.tck.bvtool.etsi.data.sms.SMS_PP_TLV;
import com.sun.tck.bvtool.etsi.gp.GPCardService;
import com.sun.tck.bvtool.etsi.gsm.ProactiveCommandTLV;
import com.sun.tck.bvtool.etsi.tlv.ConstantBundle;
import com.sun.tck.bvtool.etsi.tlv.Encodable;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.RawTLV;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.me.utils.User;
import com.sun.tck.me.utils.Utils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMSChannel {
    private static final byte ZERO = 0;
    public static final String RESPONSE_APDU_PATH = "SMS-TPDU/response/response-apdus";
    public static final String RESPONSE_HEADER = "SMS-TPDU/response/command-header";
    public static final int SW_OK = 36864;
    private GPCardService service;
    private Card card;
    private User user = new User(User.NOT_INTERACTIVE);
    private ConstantBundle responseCodes = new ConstantBundle(false, ResponseHeader.class);
    private Object monitor = new Object();

    public SMSChannel(GPCardService service) {
        this.service = service;
    }

    public void setUser(User.UserConfirmation confirm) {
        confirm = confirm == null ? User.NOT_INTERACTIVE : confirm;
        this.user = new User(confirm);
        if (this.card != null) {
            this.card.setUser(this.user);
        }
    }

    public void setCard(Card card) {
        this.card = card;
        card.setUser(this.user);
    }

    public ResponseAPDU initCard() throws Exception {
        this.user.log("TERMINAL PROFILE");
        CommandAPDU apdu = new CommandAPDU(-128, 16, 0, 0, Utils.parse("130180020000000000"), 0);
        ResponseAPDU answer = this.service.sendAPDU(apdu);
        if (SMSChannel.isProactiveCommand(answer)) {
            int sw = answer.sw();
            answer = this.service.sendAPDU(new CommandAPDU(new byte[]{-128, 18, 0, 0, (byte)sw}));
            ProactiveCommandTLV tlv = new ProactiveCommandTLV();
            tlv.decode(this.service.getFactory(), new TLVBuffer(answer.getResponseData()));
            return this.service.sendAPDU(SMSChannel.createTerminalResponseOK(tlv));
        }
        return answer;
    }

    public List<ResponseAPDU> sendSMS(CommandAPDU ... apdus) throws Exception {
        ProactiveCommandTLV tlv;
        this.checkInitialization(this.card);
        while (!this.process(tlv = this.sendSingleSMS(apdus))) {
            this.card.logCardInfo();
            this.user.checkYes("Resending TLV: Continue?");
        }
        return (List)tlv.get(RESPONSE_APDU_PATH);
    }

    public void powerReset() {
        if (this.card != null) {
            this.card.isInitalized = false;
        }
    }

    private boolean process(ProactiveCommandTLV apdu) throws CardProxyException {
        ResponseHeader header = (ResponseHeader)apdu.get(RESPONSE_HEADER);
        if (header == null) {
            throw new DeploymentException("Can not find Response Header");
        }
        this.user.log("Response-Code:" + this.responseCodes.find(header.status()));
        switch (header.status()) {
            case 0: {
                this.card.confirmCounter();
                return true;
            }
            case 9: {
                this.card.confirmCounter();
                throw new FatalException(FatalException.Scope.Card, "TAR is not supported");
            }
            case 2: {
                this.card.increaseCounter();
                break;
            }
            case 3: {
                this.card.decreaseCounter();
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                this.card.changeKeyVersion();
                break;
            }
            case 7: {
                this.card.confirmCounter();
                throw new OutOfMemoryOnCardException();
            }
            case 8: {
                this.card.confirmCounter();
                this.sleep();
                break;
            }
            case 10: {
                this.card.increaseSecurityLevel();
                break;
            }
            default: {
                throw new DeploymentException("Unknown status:" + header.status());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.wait(2000L);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private ProactiveCommandTLV fetch(Card card, int le) throws CardProxyException, EncodingException {
        this.user.log("FETCH PROACTIVE COMMAND");
        ResponseAPDU answer = this.service.sendAPDU(new CommandAPDU(new byte[]{-128, 18, 0, 0, (byte)le}));
        ProactiveCommandTLV tlv = new ProactiveCommandTLV();
        byte[] data = answer.getResponseData();
        this.log("GET SMS RESPONSE:" + Utils.canonize(data));
        tlv.decode(new TLVPrototypeFactory(card), new TLVBuffer(data));
        this.log("TERMINAL RESPONSE OK");
        this.service.sendAPDU(SMSChannel.createTerminalResponseOK(tlv));
        return tlv;
    }

    private ProactiveCommandTLV sendSingleSMS(CommandAPDU ... apdus) throws CardProxyException {
        try {
            int counter = this.card.getCounter();
            this.card.logCardInfo();
            if (counter > 4096) {
                this.user.checkYes("!!!WARNING: Counter is too high. It might block the card prematurely. Are you sure?");
            }
            int length = 104;
            List<SMS_PP_TLV> smsList = SMS_PP_TLV.create(this.card, length, apdus);
            for (SMS_PP_TLV sms : smsList) {
                this.user.log("SEND SMS: " + sms.getShortDescription());
                ResponseAPDU answer = this.service.sendAPDU(new CommandAPDU(-128, -62, 0, 0, sms.toByteArray(), 0));
                if (!SMSChannel.isProactiveCommand(answer)) continue;
                return this.fetch(this.card, answer.sw() & 0xFF);
            }
        }
        catch (EncodingException e) {
            throw new DeploymentException("Can not create or parse TLV", e);
        }
        throw new DeploymentException("there is no expected proactive command");
    }

    private void checkInitialization(Card card) throws Exception {
        if (card.isInitalized) {
            return;
        }
        ResponseAPDU apdu = this.initCard();
        SMSChannel.check(apdu, 36864);
        card.isInitalized = true;
    }

    private static boolean compare(ResponseAPDU apdu, int expected, int mask) {
        int sw = apdu.sw();
        return (sw & mask & 0xFFFF) == (expected & 0xFFFF);
    }

    private static void check(ResponseAPDU apdu, int expected) throws EncodingException {
        SMSChannel.check(apdu, expected, 65535);
    }

    private static void check(ResponseAPDU apdu, int expected, int mask) throws EncodingException {
        if (!SMSChannel.compare(apdu, expected, mask)) {
            throw new EncodingException("Incorrect sw:0x" + Integer.toHexString(apdu.sw()));
        }
    }

    private static boolean isProactiveCommand(ResponseAPDU answer) {
        return 37120 == (0xFF00 & answer.sw());
    }

    private static CommandAPDU createTerminalResponseOK(ProactiveCommandTLV command) throws EncodingException {
        TLVBuffer data = new TLVBuffer(256);
        ((Encodable)command.get("command-details")).encode(data);
        data.write(2181202561L, 4);
        new RawTLV(-125, "00").encode(data);
        byte[] bytes = new byte[data.getPos()];
        System.arraycopy(data.getBuffer(), 0, bytes, 0, bytes.length);
        return new CommandAPDU(-128, 20, 0, 0, bytes, 0);
    }

    private void log(Object msg) {
        this.service.out.println(msg);
    }
}

