/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.gp;

import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.tck.bvtool.etsi.gp.GPCardService;
import com.sun.tck.bvtool.etsi.gp.GSMCardConfigurator;
import com.sun.tck.bvtool.etsi.gsm.SMSChannel;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLVEncoder;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.bvtool.terminal.CardStore;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import com.sun.tck.jc.javatest.services.BVTDiscoveryUtils;
import com.sun.tck.me.utils.CommandLine;
import com.sun.tck.me.utils.CommandLineAdapter;
import com.sun.tck.me.utils.User;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPOverETSICardService
extends GPCardService {
    private static final int SINGLE_SMS_HEADER_LENGTH = 150;
    private static final int HEADER_LENGTH = 37;
    private static final int APDU_LENGTH = 254;
    private SMSChannel cards;
    private boolean useSmsChain = true;
    private int bundleSize = 4;
    private boolean doCleanUp = true;

    public GPOverETSICardService() {
        this.parser = new TLVPrototypeFactory();
        this.cards = new SMSChannel(this);
    }

    public void setCard(Card card) {
        this.parser.setCard(card);
        this.cards.setCard(card);
        this.card = card;
    }

    public void setSmsChainMode(boolean useSmsChain) {
        this.useSmsChain = useSmsChain;
    }

    @Override
    public ResponseAPDU sendApduToCardManager(CommandAPDU apdu) throws CardProxyException {
        return this.sendApduListToCardManager(apdu).get(0);
    }

    public void setBundleSize(int bundleSize) {
        this.bundleSize = bundleSize;
    }

    @Override
    public List<ResponseAPDU> sendApduListToCardManager(CommandAPDU ... apdus) throws CardProxyException {
        int currentBundleSize;
        int n = currentBundleSize = this.useSmsChain ? this.bundleSize : 1;
        if (apdus.length > currentBundleSize) {
            int length;
            ArrayList<ResponseAPDU> retVal = new ArrayList<ResponseAPDU>();
            for (int pos = 0; pos < apdus.length; pos += length) {
                length = Math.min(currentBundleSize, apdus.length - pos);
                CommandAPDU[] part = new CommandAPDU[length];
                System.arraycopy(apdus, pos, part, 0, length);
                retVal.addAll(this.sendApduListToCardManager(part));
            }
            return retVal;
        }
        try {
            this.out("===================sendApduToCardManager===================");
            for (CommandAPDU apdu : apdus) {
                this.out("  " + apdu);
            }
            this.out("===========================================================");
            List<ResponseAPDU> list = this.cards.sendSMS(apdus);
            this.out("LIST:" + list);
            return list;
        }
        catch (CardProxyException e) {
            throw e;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CardProxyException("Error:" + ex);
        }
    }

    @Override
    public void resetCard() throws CardProxyException {
        if (this.card == null || !this.doCleanUp) {
            return;
        }
        List<AppletID> list = this.card.getInstalledPackages();
        for (int i = list.size() - 1; i >= 0; --i) {
            AppletID current = list.get(i);
            try {
                this.deletePackageAndInstances(current, "restored-aid-without-name");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(this.out);
            }
        }
    }

    @Override
    public void selectInstaller() throws CardProxyException {
        this.reset();
    }

    @Override
    public void setCardTerminal(StatefulCardTerminal terminal) {
        super.setCardTerminal(terminal);
        this.setCard(terminal.getInsertedCard());
    }

    @Override
    protected Object[] getConfigurables() {
        return new Object[]{new GSMCardConfigurator()};
    }

    @Override
    public void validate(Object[] configurables) throws Exception {
        GSMCardConfigurator configurator = (GSMCardConfigurator)configurables[0];
        configurator.init();
        Card configuredCard = configurator.getCard();
        if (configuredCard != null) {
            this.setCard(configuredCard);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopTest() throws CardProxyException {
        super.stopTest();
        try {
            CardStore store;
            if (this.card != null) {
                this.card.flush();
            }
            CardStore cardStore = store = BVTDiscoveryUtils.getCardStore();
            synchronized (cardStore) {
                store.close();
            }
        }
        catch (CardProxyException e) {
            throw e;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void init(String[] args, PrintWriter out, PrintWriter ref) {
        ArrayList<String> tail = new ArrayList<String>();
        for (String arg : args) {
            if (arg.equalsIgnoreCase("-doNotCleanCards")) {
                this.doCleanUp = false;
                continue;
            }
            tail.add(arg);
        }
        super.init(tail.toArray(new String[tail.size()]), out, ref);
        this.cards.setUser(User.createNotInteractiveUser(out));
    }

    public ResponseAPDU send_sms(CommandAPDU apdu) throws CardProxyException {
        return this.sendApduToCardManager(apdu);
    }

    public ResponseAPDU send(CommandAPDU apdu) throws CardProxyException {
        return this.sendAPDU(apdu);
    }

    @Override
    public void powerDown() throws CardProxyException {
        super.powerDown();
        this.cards.powerReset();
    }

    @Override
    public int getHeaderLength() {
        return this.useSmsChain ? super.getHeaderLength() : 150;
    }

    @Override
    public boolean deleteObject(AppletID aid, boolean deleteRelated) throws CardProxyException {
        try {
            return super.deleteObject(aid, deleteRelated);
        }
        catch (DeploymentException e) {
            e.printStackTrace(this.out);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean installCAPFile(AppletProperties[] applets, String catFile, String outputDir) throws CardProxyException {
        try {
            return super.installCAPFile(applets, catFile, outputDir);
        }
        catch (DeploymentException e) {
            if (!this.useSmsChain) {
                throw e;
            }
            this.out("SMS-PROTOCOL:Deployment of the cap file using multiply SMS fails.");
            this.out("Trying to use single SMS");
            boolean useSmsChainStored = this.useSmsChain;
            this.useSmsChain = false;
            try {
                boolean bl = super.installCAPFile(applets, catFile, outputDir);
                Object var7_7 = null;
                this.useSmsChain = useSmsChainStored;
                return bl;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.useSmsChain = useSmsChainStored;
                throw throwable;
            }
        }
    }

    @Override
    protected void encodeInstallParameters(TLVEncoder out, AppletProperties applet) throws EncodingException {
        super.encodeInstallParameters(out, applet);
    }

    protected void encodeUICC_SystemSpecificParameters(TLVEncoder out, AppletProperties applet) throws EncodingException {
        String[] menu = new String[]{"demo1"};
        out.startTag(234, "UICC System Specific Parameters");
        out.startTag(128, "UICC Toolkit Application specific parameters");
        out.out().write(1);
        out.out().write(1);
        out.out().write(16);
        out.out().write(menu.length);
        for (int i = 0; i < menu.length; ++i) {
            out.out().write(i);
            out.out().write(0);
        }
        out.out().write(4);
        out.out().write(0);
        out.out().write(3);
        out.out().write(1);
        out.out().write(1);
        out.out().write(1);
        out.out().write(1);
        out.end("UICC Toolkit Application specific parameters");
        out.end("UICC System Specific Parameters");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] list) throws Exception {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(System.out));
        GPOverETSICardService service = new GPOverETSICardService();
        GSMCardConfigurator configurator = new GSMCardConfigurator();
        try {
            CommandLine cmd = new CommandLine(service);
            CommandLineAdapter adapter = new CommandLineAdapter(service, cmd, configurator);
            adapter.init(list);
            configurator.init();
            service.setCard(configurator.getCard());
            service.init(new String[]{"-doNotCleanCards"}, out, out);
            service.startTest(".", 10);
            out.flush();
            service.cards.setUser(cmd.isBatch() ? User.NOT_INTERACTIVE : User.INTERACTIVE);
            cmd.run();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            configurator.close();
            out.flush();
            Card card = configurator.getCard();
            if (card != null) {
                card.flush();
            }
            service.stop();
            throw throwable;
        }
        configurator.close();
        out.flush();
        Card card = configurator.getCard();
        if (card != null) {
            card.flush();
        }
        service.stop();
    }
}

