/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.data.sms;

import com.sun.tck.bvtool.etsi.data.ResponsePacket;
import com.sun.tck.bvtool.etsi.data.sms.Phone;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLV;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TreeNode;

public class SMSParser {
    public static Object parseValidityPeriod(int header, TLVBuffer in) throws EncodingException {
        if ((header & 0x18) == 0) {
            return null;
        }
        return Long.toHexString(in.read(7));
    }

    public static void initSMS(TLV parent, byte[] data) throws EncodingException {
        TLVBuffer buff = new TLVBuffer(data);
        int header = 0xFF & data[0];
        int TP_MTI = header & 3;
        switch (TP_MTI) {
            case 0: {
                SMSParser.parse_SMS_Deliver_Report(parent, buff);
                break;
            }
            case 1: {
                SMSParser.parse_SMS_Submit(parent, buff);
                break;
            }
            case 2: {
                SMSParser.parse_SMS_Command(parent, buff);
                break;
            }
            default: {
                throw new EncodingException("Unknown type: " + TP_MTI);
            }
        }
    }

    private static void parse_SMS_Deliver_Report(TLV parent, TLVBuffer data) throws EncodingException {
        parent.add("header", new TreeNode.Data("header", data.read()));
    }

    private static void parse_SMS_Command(TLV parent, TLVBuffer data) {
    }

    private static void parse_SMS_Submit(TLV parent, TLVBuffer data) throws EncodingException {
        int header = data.read();
        parent.addByte("header", header);
        parent.addByte("TP-MR", data.read());
        parent.add("TP-DA", new TreeNode.Value("TP-DA", Phone.parseTP_DA(data)));
        parent.addByte("TP-PID", data.read());
        parent.addByte("TP-DCS", data.read());
        Object tpVp = SMSParser.parseValidityPeriod(header, data);
        if (tpVp != null) {
            parent.add("TP-VP", new TreeNode.Value("TP-VP", tpVp));
        }
        int length = data.read();
        parent.add("UDL-HEADER", new TreeNode.Data("UDL-HEADER", data.readArray(3)));
        ResponsePacket pack = new ResponsePacket();
        pack.setCompactMode(true);
        pack.decode(parent.getFactory(), data);
        parent.add("response", pack);
    }

    static int swapNibble(int value, int inBase) {
        return SMSParser.swapNibble(value, inBase, 16);
    }

    static int swapNibble(int value, int inBase, int outBase) {
        return (value %= inBase * inBase) % inBase * outBase + value / inBase;
    }
}

