/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.data;

import com.sun.tck.bvtool.etsi.tlv.Encodable;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLV;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import com.sun.tck.bvtool.etsi.tlv.TLVUtils;
import com.sun.tck.bvtool.etsi.tlv.TreeNode;
import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.me.utils.Tracer;
import java.security.GeneralSecurityException;

public abstract class SecuredPacketTLV
extends TLV {
    private State state = State.CREATED;
    protected Header header = this.createHeader();
    protected Card card;
    protected boolean isCompact = true;

    protected final void writeData(TLVBuffer buff) throws Exception {
    }

    public final void decodeData(TLVPrototypeFactory processor, TLVBuffer in) throws Exception {
    }

    public SecuredPacketTLV() {
        this.add("command-header", this.header);
    }

    protected abstract Header createHeader();

    public void setCompactMode(boolean isCompact) {
        this.isCompact = isCompact;
    }

    public void init(Card card) {
        this.card = card;
        this.header.init(card);
    }

    public void decode(TLVPrototypeFactory processor, TLVBuffer in) throws EncodingException {
        int length;
        TLVBuffer.Position start = in.createPosition();
        HeaderDecoder decoder = this.header.decoder();
        TLVBuffer.Position mark = in.createPosition();
        if (this.isCompact) {
            length = (int)in.read(2);
        } else {
            this.setTag((byte)TLVUtils.readTag(in), null);
            length = TLVUtils.readLength(in);
        }
        TLVBuffer.Position dataStart = in.createPosition();
        TLVBuffer current = in.createChild(mark, length + dataStart.pos - mark.pos);
        Tracer.trace("ENCRYPTED-STEP:" + current);
        decoder.setBuffer(current, start, dataStart);
        decoder.parseHeader();
        try {
            decoder.decrypt();
            Tracer.trace("DECRYPTED-STEP:" + current);
            this.state = State.ENCRYPTED;
            decoder.parseDecryptedHeader();
            decoder.verify();
            TLVBuffer secured = decoder.getSecuredData();
            this.decodeSecuredData(processor, secured);
            this.state = State.VERIFYED;
        }
        catch (GeneralSecurityException e) {
            throw new EncodingException("security configuration error", e);
        }
        catch (Exception e) {
            throw new EncodingException("Unknown Exception", e);
        }
    }

    protected void decodeSecuredData(TLVPrototypeFactory processor, TLVBuffer securedData) throws Exception {
        securedData.reset();
        while (securedData.available() > 0) {
            TLV child = processor.create(TLVUtils.lookupTag(securedData));
            child.decode(processor, securedData);
            this.add(child);
        }
    }

    protected void writeSecuredData(TLVBuffer buff) throws EncodingException {
        for (TreeNode treeNode : this.childNodes().values()) {
            if (!(treeNode instanceof Encodable)) continue;
            ((Encodable)((Object)treeNode)).encode(buff);
        }
    }

    public void encode(TLVBuffer buff) throws EncodingException {
        HeaderEncoder encoder = this.header.encoder();
        TLVBuffer.Position startBuffer = buff.createPosition();
        if (!this.isCompact) {
            buff.write(this.getTag());
        }
        TLVBuffer lengthBuff = buff.createChild(this.isCompact ? 2 : 1);
        TLVBuffer.Position startBody = buff.createPosition();
        encoder.setBuffer(buff, startBuffer, startBody);
        TLVBuffer securedBuff = new TLVBuffer(1024);
        this.writeSecuredData(securedBuff);
        byte[] securedData = new byte[securedBuff.getPos()];
        System.arraycopy(securedBuff.getBuffer(), 0, securedData, 0, securedData.length);
        encoder.setData(securedData);
        encoder.write(buff);
        Tracer.trace("ENCODED       :" + buff);
        int length = buff.getPos() - startBody.pos;
        if (this.isCompact) {
            lengthBuff.write(length, 2);
        } else {
            TLVUtils.writeLength(lengthBuff, length);
        }
        this.state = State.ENCODED;
        try {
            encoder.sign();
            this.state = State.SIGNED;
            Tracer.trace("SIGNED-STEP   :" + buff);
            encoder.encrypt();
            this.state = State.ENCRYPTED;
            Tracer.trace("ENCRYPTED-STEP:" + buff);
        }
        catch (GeneralSecurityException e) {
            throw new EncodingException("security configuration error", e);
        }
    }

    public static interface HeaderDecoder {
        public void setBuffer(TLVBuffer var1, TLVBuffer.Position var2, TLVBuffer.Position var3);

        public void parseHeader() throws EncodingException;

        public void decrypt() throws GeneralSecurityException;

        public void parseDecryptedHeader() throws EncodingException;

        public void verify() throws GeneralSecurityException, EncodingException;

        public TLVBuffer getSecuredData();
    }

    public static interface Header
    extends TreeNode {
        public void init(Card var1);

        public int getTAR();

        public void setTAR(int var1);

        public HeaderDecoder decoder();

        public HeaderEncoder encoder();
    }

    public static interface HeaderEncoder {
        public void setBuffer(TLVBuffer var1, TLVBuffer.Position var2, TLVBuffer.Position var3);

        public void setData(byte[] var1);

        public void write(TLVBuffer var1) throws EncodingException;

        public void sign() throws GeneralSecurityException, EncodingException;

        public void encrypt() throws GeneralSecurityException, EncodingException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        CREATED,
        ENCODED,
        SIGNED,
        ENCRYPTED,
        DECRYPTED,
        VERIFYED;

    }
}

