/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.jck.lib.I18n;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;

public abstract class MessageClient
implements Runnable {
    private String name;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private Thread listener;
    private static final int STARTING = 0;
    private static final int RUNNING = 1;
    private static final int CLOSING = 2;
    private static final int CLOSED = 3;
    private int state;
    static final int NAME = 1;
    static final int BROADCAST = 2;
    static final int SEND = 3;
    static final int MESSAGE = 100;

    public MessageClient(String name, String hostAndPort) throws IOException {
        this(name, MessageClient.openSocket(hostAndPort));
    }

    public MessageClient(String name, String host, int port) throws IOException {
        this(name, new Socket(host, port));
    }

    public MessageClient(String name, Socket socket) throws IOException {
        this.name = name;
        this.socket = socket;
        this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    public synchronized void broadcast(String[] args) throws IOException {
        if (this.listener == null) {
            throw new IllegalStateException();
        }
        this.out.writeByte(2);
        this.out.writeShort(args.length);
        for (int i = 0; i < args.length; ++i) {
            this.out.writeUTF(args[i]);
        }
        this.out.flush();
    }

    public synchronized void send(String taskName, String[] args) throws IOException {
        if (this.listener == null) {
            throw new IllegalStateException();
        }
        this.out.writeByte(3);
        this.out.writeUTF(taskName);
        this.out.writeShort(args.length);
        for (int i = 0; i < args.length; ++i) {
            this.out.writeUTF(args[i]);
        }
        this.out.flush();
    }

    public synchronized void close() {
        if (this.state < 2) {
            this.state = 2;
            try {
                this.in.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.listener.interrupt();
            this.listener = null;
        }
    }

    public synchronized void start() throws InterruptedException {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = new Thread((Runnable)this, "MessageClient");
        this.listener.start();
        while (this.state == 0) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MessageClient messageClient = this;
        synchronized (messageClient) {
            if (this.listener == null) {
                this.listener = Thread.currentThread();
            } else if (this.listener != Thread.currentThread()) {
                throw new IllegalStateException();
            }
        }
        try {
            this.out.writeByte(1);
            this.out.writeUTF(this.name);
            this.out.flush();
            messageClient = this;
            synchronized (messageClient) {
                this.state = 1;
                this.notifyAll();
            }
            while (this.state == 1) {
                byte code;
                try {
                    code = this.in.readByte();
                }
                catch (EOFException e) {
                    MessageClient messageClient2 = this;
                    synchronized (messageClient2) {
                        this.state = 3;
                        this.notifyAll();
                    }
                    return;
                }
                switch (code) {
                    case 100: {
                        String from = this.in.readUTF();
                        int n = this.in.readShort();
                        String[] args = new String[n];
                        for (int i = 0; i < n; ++i) {
                            args[i] = this.in.readUTF();
                        }
                        this.handleMessage(from, args);
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
        finally {
            MessageClient messageClient3 = this;
            synchronized (messageClient3) {
                this.state = 3;
                this.notifyAll();
            }
        }
    }

    public synchronized void waitUntilClosed() throws InterruptedException {
        while (this.state != 3) {
            this.wait();
        }
    }

    protected abstract void handleException(Exception var1);

    protected abstract void handleMessage(String var1, String[] var2);

    private static Socket openSocket(String hostAndPort) throws IOException {
        int colon = hostAndPort.indexOf(58);
        if (colon == -1) {
            throw new IllegalArgumentException(I18n.getString("no.port.specified"));
        }
        return new Socket(hostAndPort.substring(0, colon), Integer.parseInt(hostAndPort.substring(colon + 1)));
    }
}

