/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.finder.HTMLTestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class JCKTestFinder
extends HTMLTestFinder {
    private boolean verify;
    private String[] requiredEntries = JCKTestFinder.getRequiredEntries();
    private Map validEntries = JCKTestFinder.initTable(JCKTestFinder.getValidEntries());
    private Map validKeywords = JCKTestFinder.initTable(JCKTestFinder.getValidKeywords());
    private static final String TESTSUITE_HTML = "testsuite.html";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(JCKTestFinder.class);

    public void init(String[] args, File testSuiteRoot, TestEnvironment env) throws TestFinder.Fault {
        this.setMode(2);
        this.decodeAllArgs(args);
        this.setRoot(testSuiteRoot);
    }

    public void setVerify(boolean f) {
        this.verify = f;
    }

    public void setRoot(File testSuiteRoot) throws TestFinder.Fault {
        int mode = this.getMode();
        if (testSuiteRoot.isDirectory()) {
            File f = new File(testSuiteRoot, TESTSUITE_HTML);
            if (!f.exists() || f.isDirectory() || !f.canRead()) {
                throw new TestFinder.Fault(i18n, "jckFinder.badRootDir", new Object[]{TESTSUITE_HTML, testSuiteRoot.getPath()});
            }
            if (mode == 1) {
                testSuiteRoot = f;
            }
        } else {
            String name = testSuiteRoot.getName();
            if (!name.equals(TESTSUITE_HTML)) {
                throw new TestFinder.Fault(i18n, "jckFinder.badRootFile");
            }
            if (mode == 2) {
                testSuiteRoot = new File(testSuiteRoot.getParent());
            }
        }
        super.setRoot(testSuiteRoot);
    }

    protected int decodeArg(String[] args, int i) throws TestFinder.Fault {
        if (args[i].equals("-verify")) {
            this.verify = true;
            return 1;
        }
        if (args[i].equals("-allowEntry")) {
            String e = args[i + 1];
            this.validEntries.put(e.toLowerCase(), e);
            return 2;
        }
        if (args[i].equals("-allowKeyword")) {
            String k = args[i + 1];
            this.validKeywords.put(k.toLowerCase(), k);
            return 2;
        }
        return super.decodeArg(args, i);
    }

    protected void processEntry(Map entries, String name, String value) {
        boolean valid;
        boolean bl = valid = this.validEntries.get(name.toLowerCase()) != null;
        if (this.verify) {
            if (!valid) {
                this.error(i18n, "jckFinder.unknownEntry", new Object[]{name, this.getCurrentFile()});
            }
            if (name.equalsIgnoreCase("keywords")) {
                String[] keys = StringArray.split((String)value);
                boolean foundRuntime = false;
                boolean foundCompiler = false;
                if (keys != null) {
                    for (int i = 0; i < keys.length; ++i) {
                        String key = keys[i];
                        if (this.validKeywords.get(key.toLowerCase()) == null) {
                            this.error(i18n, "jckFinder.unknownKeyword", new Object[]{key, this.getCurrentFile()});
                        }
                        if (key.equals("runtime")) {
                            foundRuntime = true;
                            continue;
                        }
                        if (!key.equals("compiler")) continue;
                        foundCompiler = true;
                    }
                }
                if (!foundRuntime && !foundCompiler) {
                    this.error(i18n, "jckFinder.needCompOrRuntimeKeyword", this.getCurrentFile());
                }
            }
        }
        if (valid) {
            String prevValue;
            if (name.equalsIgnoreCase("remote") && (prevValue = (String)entries.get(name)) != null) {
                value = prevValue + "\n" + value.trim();
            }
            super.processEntry(entries, name, value);
        }
    }

    protected Map normalize(Map entries) {
        if (this.verify) {
            for (int i = 0; i < this.requiredEntries.length; ++i) {
                if (entries.get(this.requiredEntries[i]) != null) continue;
                this.error(i18n, "jckFinder.requiredEntryNotFound", new Object[]{this.requiredEntries[i], this.getCurrentFile()});
            }
        }
        return entries;
    }

    private static Map initTable(String[] entries) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < entries.length; ++i) {
            map.put(entries[i].toLowerCase(), entries[i]);
        }
        return map;
    }

    public static String[] getRequiredEntries() {
        return new String[]{"keywords", "source", "title"};
    }

    public static String[] getValidEntries() {
        return new String[]{"keywords", "source", "title", "context", "executeArgs", "executeClass", "executeNative", "id", "remote", "rmicClass", "rmicClasses", "selectIf", "executeIf", "timeout"};
    }

    public static String[] getValidKeywords() {
        return new String[]{"compiler", "runtime", "positive", "negative", "idl_inherit", "idl_tie", "interactive", "jniinvocationapi", "only_once", "rmi_iiop", "rmi_v11", "serial"};
    }
}

