/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.referenceimpl;

import com.sun.javacard.cjck.I18n;
import java.io.PrintWriter;

public class Logger {
    public static final int DEBUG_TRACE = 0;
    public static final int DEBUG = 1;
    public static final int MESSAGE = 2;
    public static final int ERROR = 3;
    private PrintWriter out;
    private PrintWriter err;
    private int debug_level;

    public Logger(int level, PrintWriter out, PrintWriter err) {
        if (out == null || err == null) {
            throw new IllegalArgumentException(I18n.getString("null.printwriter"));
        }
        this.out = out;
        this.err = err;
        this.debug_level = level;
    }

    public Logger(int level, PrintWriter out) {
        if (out == null) {
            throw new IllegalArgumentException(I18n.getString("null.printwriter"));
        }
        this.out = out;
        this.err = out;
        this.debug_level = level;
    }

    void logInternal(String msg, int debug_level, PrintWriter log) {
        if (debug_level >= this.debug_level) {
            long currentTime;
            long logTime = currentTime = System.currentTimeMillis();
            log.println(I18n.getString("log.time", Long.toString(logTime), msg));
        }
    }

    public void log(String msg, int debug_level) {
        this.logInternal(msg, debug_level, this.out);
    }

    public void err(String msg, int debug_level) {
        this.logInternal(msg, debug_level, this.err);
    }

    public void setDebugLevel(int level) {
        this.debug_level = level;
        this.log(I18n.getString("change.debug.level", new Integer(this.debug_level), new Integer(level)), 1);
    }

    public int getLevel() {
        return this.debug_level;
    }

    public boolean isDebugEnabled() {
        return this.debug_level <= 1;
    }

    public boolean isTraceEnabled() {
        return this.debug_level == 0;
    }

    public boolean isMessageEnabled() {
        return this.debug_level <= 2;
    }
}

