/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.ArgumentParser;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigFileReader {
    static String BUILD_VERSION = "Version: %Z%";
    static String BUILD_DATE = "%E%";
    private static PrintWriter stdOut;
    private static PrintWriter stdErr;
    private static final int MAX_APPS = 100;
    private static final String EOL;
    static byte PACKAGE_AID_LAST_BYTE_MASK;
    String configFile;
    private Vector appVec = new Vector();
    private Vector packageOrder;
    private Hashtable packages = new Hashtable();
    static String config_id;

    public ConfigFileReader(PrintWriter out, PrintWriter err) {
        this.packageOrder = new Vector();
        stdOut = out == null ? new PrintWriter(System.out, true) : out;
        stdErr = err == null ? new PrintWriter(System.err, true) : err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String file) throws IOException {
        config_id = I18n.getString("config.id");
        ConfigFileReader.log(I18n.getString("config.verion", config_id, BUILD_VERSION, BUILD_DATE));
        this.configFile = file;
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim().replace('\t', ' ')).startsWith("//") || line.length() == 0) continue;
                StringTokenizer tokens = new StringTokenizer(line, " ");
                if (tokens.countTokens() < 2) {
                    throw new RuntimeException(I18n.getString("missing.aid", line));
                }
                String fullname = tokens.nextToken();
                if (fullname.equals("package")) {
                    this.parsePackage(tokens);
                    continue;
                }
                String packageName = fullname.substring(0, fullname.lastIndexOf("."));
                String aidString = tokens.nextToken();
                byte[] aidBytes = ConfigFileReader.convertHexToBytes(aidString, 26);
                AppletID packageAID = this.getPackageAID(packageName);
                if (packageAID == null) {
                    byte[] packageBytes = new byte[aidBytes.length];
                    System.arraycopy(aidBytes, 0, packageBytes, 0, aidBytes.length);
                    int n = packageBytes.length - 1;
                    packageBytes[n] = (byte)(packageBytes[n] & PACKAGE_AID_LAST_BYTE_MASK);
                    packageAID = new AppletID(packageBytes);
                }
                AppletID aid = new AppletID(aidBytes);
                AppletProperties appProperties = new AppletProperties(packageName, packageAID, fullname);
                appProperties.setAID(aid);
                this.addPackage(packageName, packageAID, tokens.hasMoreTokens() ? tokens.nextToken() : null, tokens.hasMoreTokens());
                this.addApplet(packageName, packageAID, appProperties);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void parsePackage(Enumeration e) {
        String name = (String)e.nextElement();
        byte[] aidBytes = ConfigFileReader.convertHexToBytes((String)e.nextElement(), 26);
        String version = e.hasMoreElements() ? (String)e.nextElement() : null;
        this.addPackage(name, new AppletID(aidBytes), version, e.hasMoreElements());
    }

    private void addPackage(String name, AppletID aid, String version, boolean exportMap) {
        Info last = (Info)this.packages.get(name);
        if (last == null) {
            this.packages.put(name, new Info(name, aid, version, exportMap));
            this.packageOrder.addElement(name);
        } else if (!aid.equals(last.getPackageAID()) || version != last.getVersion() && version != null) {
            throw new IllegalArgumentException(I18n.getString("package.aid.not.equal"));
        }
    }

    private void addApplet(String name, AppletID aid, AppletProperties ap) {
        Info last = (Info)this.packages.get(name);
        last.addApplet(ap);
        this.appVec.addElement(ap);
    }

    public Enumeration getPackages() {
        return this.packageOrder.elements();
    }

    public AppletID getPackageAID(String name) {
        Info data = (Info)this.packages.get(name);
        return data == null ? null : data.getPackageAID();
    }

    public boolean isExportMap(String name) {
        Info data = (Info)this.packages.get(name);
        return data.isExportMap();
    }

    public String getPackageVersion(String name) {
        Info data = (Info)this.packages.get(name);
        return data == null ? null : data.getVersion();
    }

    public AppletProperties[] getApplets(String name) {
        Info data = (Info)this.packages.get(name);
        return data == null ? null : data.getApplets();
    }

    public AppletProperties[] getPropertiesByCapFile(String name) throws IllegalArgumentException {
        String shortName = name;
        if (name.endsWith(".cap")) {
            shortName = name.substring(0, name.lastIndexOf(".cap"));
        }
        shortName = ArgumentParser.getBasename(shortName);
        Vector<String> h = new Vector<String>();
        Enumeration e = this.getPackages();
        while (e.hasMoreElements()) {
            String next = (String)e.nextElement();
            String s = next.replace('.', File.separatorChar);
            if (!shortName.equals(s = ArgumentParser.getBasename(s))) continue;
            h.addElement(next);
        }
        if (h.size() == 0) {
            throw new IllegalArgumentException(I18n.getString("package.not.found", name));
        }
        if (h.size() != 1) {
            throw new IllegalArgumentException(I18n.getString("more.packages.found", name));
        }
        return this.getApplets((String)h.elementAt(0));
    }

    public AppletProperties[] getAppletPropertiesArray() {
        return this.appVec.toArray(new AppletProperties[this.appVec.size()]);
    }

    public Vector getAppletVector() {
        return this.appVec;
    }

    public Enumeration elements() {
        return this.appVec.elements();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Applet Class\tAppletID\tParms");
        sb.append(EOL);
        int handle = 1;
        Enumeration e = this.appVec.elements();
        while (e.hasMoreElements()) {
            AppletProperties appObj = (AppletProperties)e.nextElement();
            sb.append(handle++);
            sb.append(". ");
            sb.append(appObj);
            sb.append(EOL);
        }
        return sb.toString();
    }

    private static byte[] convertHexToBytes(String hexString, int maxLength) throws IllegalArgumentException {
        byte[] bArray = new byte[maxLength];
        int buffIndex = 0;
        int digitNumber = 0;
        hexString = hexString.trim();
        ConfigFileReader.log(I18n.getString("convert.hexstring", config_id, hexString));
        if (hexString.startsWith("0x")) {
            hexString = hexString.substring(2);
        }
        char[] aChars = hexString.toCharArray();
        for (int i = 0; i < aChars.length; ++i) {
            int theDigit;
            boolean isComma;
            boolean isColon;
            boolean bl = isColon = aChars[i] == ':';
            if (isColon && aChars[i + 1] == '0' && aChars[i + 2] == 'x') {
                i += 2;
                continue;
            }
            boolean bl2 = isComma = aChars[i] == ',';
            if (isComma || digitNumber == 2) {
                if (++buffIndex == bArray.length) {
                    throw new IllegalArgumentException(I18n.getString("invalid.hexstring", hexString));
                }
                bArray[buffIndex] = 0;
                digitNumber = 0;
                if (isComma) continue;
            }
            if ((theDigit = Character.digit(aChars[i], 16)) == -1) {
                throw new IllegalArgumentException(I18n.getString("invalid.hexstring", hexString));
            }
            bArray[buffIndex] = (byte)((bArray[buffIndex] << 4) + theDigit);
            ++digitNumber;
        }
        byte[] returnArray = new byte[buffIndex + 1];
        System.arraycopy(bArray, 0, returnArray, 0, returnArray.length);
        return returnArray;
    }

    public static void main(String[] args) {
        stdOut = new PrintWriter(System.out, true);
        stdErr = new PrintWriter(System.err, true);
        if (args.length == 0) {
            stdErr.println(I18n.getString("no.args.supply"));
            System.exit(1);
        }
        String m_configFileName = "";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-f")) {
                m_configFileName = args[++i];
                continue;
            }
            if (!args[i].equals("-verbose") && !args[i].equals("-v")) continue;
            boolean bl = true;
        }
        config_id = I18n.getString("config.id");
        ConfigFileReader.log(I18n.getString("config.filename", config_id, m_configFileName));
        ConfigFileReader cfr = null;
        try {
            cfr = new ConfigFileReader(null, null);
            cfr.read(m_configFileName);
        }
        catch (Exception e) {
            ConfigFileReader.log(I18n.getString("configfilereader.exception", config_id, e));
            System.exit(1);
        }
        AppletProperties[] apa = cfr.getAppletPropertiesArray();
        for (int i = 0; i < apa.length; ++i) {
            ConfigFileReader.log(I18n.getString("applet.properties", new Object[]{config_id, new Integer(i), apa[i].toString(), apa[i].getPackageName(), apa[i].getPackageAID()}));
        }
    }

    static void log(String msg) {
        stdOut.println(msg);
    }

    static {
        EOL = System.getProperty("line.separator", "\n");
        PACKAGE_AID_LAST_BYTE_MASK = (byte)15;
    }

    public class Info {
        private String name;
        private AppletID packageID;
        private String version;
        private boolean exportMap;
        private Vector applets = new Vector();

        public Info(String name, AppletID packageID, String version, boolean exportMap) {
            this.name = name;
            this.packageID = packageID;
            this.version = version == null ? null : version.intern();
            this.exportMap = exportMap;
        }

        public AppletID getPackageAID() {
            return this.packageID;
        }

        public String getName() {
            return this.name;
        }

        public void addApplet(AppletProperties applet) {
            this.applets.addElement(applet);
        }

        public AppletProperties[] getApplets() {
            AppletProperties[] retVal = new AppletProperties[this.applets.size()];
            return this.applets.toArray(retVal);
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isExportMap() {
            return this.exportMap;
        }
    }
}

