/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework.service;

import javacard.framework.APDU;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.framework.service.Service;
import javacard.framework.service.ServiceException;

public class Dispatcher {
    private Service[] services;
    private byte[] servicePhases;
    private short numServices;
    public static final byte PROCESS_NONE = 0;
    public static final byte PROCESS_INPUT_DATA = 1;
    public static final byte PROCESS_COMMAND = 2;
    public static final byte PROCESS_OUTPUT_DATA = 3;

    public Dispatcher(short maxServices) throws ServiceException {
        if (maxServices < 0) {
            ServiceException.throwIt((short)1);
        }
        this.services = new Service[maxServices];
        this.servicePhases = new byte[maxServices];
        this.numServices = 0;
    }

    public void addService(Service service, byte phase) throws ServiceException {
        if (phase < 0 || phase > 3) {
            ServiceException.throwIt((short)1);
        }
        if (service == null) {
            ServiceException.throwIt((short)1);
        }
        for (short i2 = 0; i2 < this.numServices; i2 = (short)(i2 + 1)) {
            if (this.services[i2] != service || this.servicePhases[i2] != phase) continue;
            return;
        }
        if (this.numServices >= this.services.length) {
            ServiceException.throwIt((short)2);
        }
        boolean inTransaction = false;
        if (JCSystem.getTransactionDepth() == 0) {
            inTransaction = true;
            JCSystem.beginTransaction();
        }
        this.servicePhases[this.numServices] = phase;
        short s2 = this.numServices;
        this.numServices = (short)(s2 + 1);
        this.services[s2] = service;
        if (inTransaction) {
            JCSystem.commitTransaction();
        }
    }

    public void removeService(Service service, byte phase) throws ServiceException {
        if (service == null) {
            ServiceException.throwIt((short)1);
        }
        if (phase < 0 || phase > 3) {
            ServiceException.throwIt((short)1);
        }
        for (short i2 = 0; i2 < this.numServices; i2 = (short)(i2 + 1)) {
            if (this.services[i2] != service || this.servicePhases[i2] != phase) continue;
            boolean inTransaction = false;
            if (JCSystem.getTransactionDepth() == 0) {
                inTransaction = true;
                JCSystem.beginTransaction();
            }
            for (short j2 = i2; j2 < (short)(this.numServices - 1); j2 = (short)(j2 + 1)) {
                this.services[j2] = this.services[(short)(j2 + 1)];
                this.servicePhases[j2] = this.servicePhases[(short)(j2 + 1)];
            }
            this.numServices = (short)(this.numServices - 1);
            if (inTransaction) {
                JCSystem.commitTransaction();
            }
            return;
        }
    }

    public Exception dispatch(APDU command, byte phase) throws ServiceException {
        if (phase < 1 || phase > 3) {
            ServiceException.throwIt((short)1);
        }
        byte[] buffer = command.getBuffer();
        try {
            short i2;
            for (i2 = 0; !(i2 >= this.numServices || phase > 1 || this.servicePhases[i2] == 1 && this.services[i2].processDataIn(command)); i2 = (short)(i2 + 1)) {
            }
            for (i2 = 0; !(i2 >= this.numServices || phase > 2 || this.servicePhases[i2] == 2 && this.services[i2].processCommand(command)); i2 = (short)(i2 + 1)) {
            }
            if (command.getCurrentState() < 3) {
                return null;
            }
            for (i2 = 0; !(i2 >= this.numServices || this.servicePhases[i2] == 3 && this.services[i2].processDataOut(command)); i2 = (short)(i2 + 1)) {
            }
        }
        catch (Exception e2) {
            return e2;
        }
        short outLength = (short)(buffer[4] & 0xFF);
        command.setOutgoingLength(outLength);
        command.sendBytes((short)5, outLength);
        ISOException.throwIt(Util.getShort(buffer, (short)2));
        return null;
    }

    public void process(APDU command) throws ISOException {
        Exception e2 = this.dispatch(command, (byte)1);
        if (e2 == null) {
            ISOException.throwIt((short)27904);
        } else {
            ISOException.throwIt((short)28416);
        }
    }
}

