/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.tools.file;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveIterator
implements Iterator<File> {
    private LinkedList inProcess = new LinkedList();
    private String root;
    private Filter filter;
    public static final Filter FILE_FILTER = new Filter(){

        public boolean accept(String root, File file) {
            return file.isFile();
        }

        public boolean doLookInside(String root, File file) {
            return true;
        }
    };

    public RecursiveIterator(String root) throws IOException {
        this(root, null, FILE_FILTER);
    }

    public RecursiveIterator(String root, String[] dirs, Filter filter) throws IOException {
        File rootFile = new File(root);
        this.filter = filter;
        this.root = rootFile.getCanonicalPath();
        if (!this.root.endsWith(File.separator)) {
            this.root = this.root + File.separator;
        }
        if (dirs != null) {
            for (int i = 0; i < dirs.length; ++i) {
                this.inProcess.addLast(new File(this.root, dirs[i]));
            }
        } else {
            this.inProcess.addLast(new File(this.root));
        }
    }

    private File processIfDirectory(File current) {
        File[] list;
        if (current != null && current.isDirectory() && (list = current.listFiles()) != null) {
            for (int i = 0; i < list.length; ++i) {
                try {
                    if (!this.isNested(current, list[i]) || !this.filter.doLookInside(this.root, list[i])) continue;
                    this.inProcess.addFirst(list[i]);
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Can not obtain canonical path: " + e);
                }
            }
        }
        return current;
    }

    private boolean isNested(File parent, File file) throws IOException {
        String parentPath = parent.getCanonicalPath();
        parentPath = parentPath.endsWith(File.separator) ? parentPath : parentPath + File.separator;
        return file.getCanonicalPath().startsWith(parentPath);
    }

    @Override
    public boolean hasNext() {
        while (!this.inProcess.isEmpty() && !this.filter.accept(this.root, (File)this.inProcess.getFirst())) {
            this.processIfDirectory((File)this.inProcess.removeFirst());
        }
        return !this.inProcess.isEmpty();
    }

    @Override
    public File next() {
        this.hasNext();
        return this.processIfDirectory((File)this.inProcess.removeFirst());
    }

    @Override
    public void remove() {
    }

    public static class ExtensionFilter
    implements Filter {
        public String[] list;

        public ExtensionFilter(String[] extensions) {
            this.list = extensions == null ? new String[]{} : extensions;
        }

        public ExtensionFilter(String extension) {
            this(new String[]{extension});
        }

        public boolean accept(String root, File file) {
            if (file.isFile()) {
                for (int i = 0; i < this.list.length; ++i) {
                    if (!file.getName().endsWith(this.list[i])) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean doLookInside(String root, File file) {
            return true;
        }
    }

    public static interface Filter {
        public boolean accept(String var1, File var2);

        public boolean doLookInside(String var1, File var2);
    }
}

