/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.tools.file;

import com.sun.tck.me.utils.Closables;
import com.sun.tck.tools.file.RecursiveIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static final int BUFFER_SIZE = 32768;
    private static volatile long globalCount = 1L;

    public static boolean move(File fromRoot, File toRoot, File file, PrintWriter log) {
        try {
            File newDest = new File(toRoot, FileUtils.getRelativePath(fromRoot, file, log));
            File dirName = newDest.getParentFile();
            if (!dirName.isDirectory() && !newDest.getParentFile().mkdirs()) {
                FileUtils.log(log, "Can not create a parent dir for " + newDest);
                return false;
            }
            return file.renameTo(newDest) || FileUtils.copyTo(file, newDest);
        }
        catch (IOException e) {
            FileUtils.logThrowable(log, e);
            return false;
        }
    }

    public static File[] split(File in, int bundleSize) throws IOException {
        return FileUtils.split(new InputStreamReader(new FileInputStream(in)), bundleSize, null, "XA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] split(Reader in, int bundleSize, File tmpDir, String prefix) throws IOException {
        File[] fileArray;
        try {
            fileArray = FileUtils.split(new InputFileIterator(in), bundleSize, tmpDir, prefix);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                in.close();
            }
            catch (IOException e) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return fileArray;
    }

    public static File[] split(Iterator<String> list, int bundleSize, File tmpDir, String prefix) throws IOException {
        long count = 1L;
        ArrayList<String> current = new ArrayList<String>();
        ArrayList<File> retVal = new ArrayList<File>();
        while (list.hasNext()) {
            if (current.size() >= bundleSize) {
                retVal.add(FileUtils.writeList(prefix, tmpDir, current));
                current = new ArrayList();
            }
            current.add(list.next());
        }
        if (current.size() > 0) {
            retVal.add(FileUtils.writeList(prefix, tmpDir, current));
        }
        return retVal.toArray(new File[retVal.size()]);
    }

    public static File createFile(File dir, String prefix) throws IOException {
        return dir == null ? File.createTempFile(prefix, "") : FileUtils.createFile(dir, prefix, globalCount);
    }

    private static File createFile(File dir, String prefix, long cnt) throws IOException {
        if (!(dir.exists() || dir.mkdirs() || dir.mkdirs() || dir.exists())) {
            throw new IOException("Can not create directory:" + dir);
        }
        File retVal = null;
        while (!(retVal = new File(dir, prefix + cnt++)).createNewFile()) {
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeList(String prefix, File tempDir, ArrayList<String> list) throws IOException {
        File file;
        block6: {
            OutputStreamWriter out = null;
            File retVal = null;
            try {
                retVal = FileUtils.createFile(tempDir, prefix);
                out = new OutputStreamWriter(new FileOutputStream(retVal));
                for (String line : list) {
                    out.write(line);
                    out.write("\n");
                }
                file = retVal;
                Object var8_7 = null;
                if (out == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var8_8 = null;
                    if (out == null) break block7;
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyTo(File from, File to) {
        Closables closables = new Closables();
        try {
            FileChannel in = closables.add(new FileInputStream(from).getChannel());
            FileChannel out = closables.add(new FileOutputStream(to).getChannel());
            long transfered = 0L;
            for (long toDo = in.size(); toDo > 0L; toDo -= in.transferTo(0L, toDo, out)) {
            }
            boolean bl = true;
            Object var11_10 = null;
            closables.close();
            return bl;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                boolean bl = false;
                Object var11_11 = null;
                closables.close();
                return bl;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                closables.close();
                throw throwable;
            }
        }
    }

    public static String getRelativePath(File fromRoot, File file, PrintWriter log) throws IOException {
        String fileName;
        String fromRootName = fromRoot.getCanonicalPath();
        if (!fromRootName.endsWith(File.separator)) {
            fromRootName = fromRootName + File.separator;
        }
        if ((fileName = file.getCanonicalPath()).startsWith(fromRootName)) {
            return fileName.substring(fromRootName.length());
        }
        FileUtils.log(log, "The file does not belong to the given root. Root=" + fromRootName + " File=" + fileName);
        throw new IllegalArgumentException("The file does not belong to the given root.");
    }

    public static void logThrowable(PrintWriter log, Throwable t) {
        if (log != null) {
            t.printStackTrace(log);
        } else {
            t.printStackTrace();
        }
    }

    public static void log(PrintWriter log, Object message) {
        if (log != null) {
            log.println(message);
        } else {
            System.out.println(message);
        }
    }

    public static boolean createZip(String zipfile, File root, RecursiveIterator.Filter filter, PrintWriter out) {
        try {
            return FileUtils.createZip(new FileOutputStream(zipfile), root, filter, out);
        }
        catch (IOException e) {
            FileUtils.logThrowable(out, e);
            return false;
        }
    }

    public static boolean createZip(OutputStream zipOut, File root, RecursiveIterator.Filter filter, PrintWriter out) {
        try {
            ZipOutputStream zip = new ZipOutputStream(zipOut);
            zip.setMethod(0);
            filter = filter == null ? RecursiveIterator.FILE_FILTER : filter;
            RecursiveIterator i = new RecursiveIterator(root.getPath(), null, filter);
            while (i.hasNext()) {
                File current = (File)i.next();
                String path = FileUtils.getRelativePath(root, current, out);
                ZipEntry entry = FileUtils.createStoredZipEntry(path, new FileInputStream(current));
                zip.putNextEntry(entry);
                FileUtils.copyStream(new FileInputStream(current), zip);
                zip.closeEntry();
            }
            zip.finish();
            zip.close();
            return true;
        }
        catch (IOException e) {
            FileUtils.logThrowable(out, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipEntry createStoredZipEntry(String name, InputStream in) throws IOException {
        ZipEntry zipEntry;
        byte[] buff = new byte[32768];
        ZipEntry entry = new ZipEntry(name);
        int size = 0;
        CRC32 crc = new CRC32();
        try {
            while (in.available() > 0) {
                int step = Math.min(32768, in.available());
                int read = in.read(buff, 0, step);
                size += read;
                crc.update(buff, 0, read);
            }
            entry.setSize(size);
            entry.setCompressedSize(size);
            entry.setCrc(crc.getValue());
            zipEntry = entry;
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return zipEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buff = new byte[32768];
        try {
            while (in.available() > 0) {
                int size = Math.min(32768, in.available());
                int read = in.read(buff, 0, size);
                out.write(buff, 0, read);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    public static File createTempDir() throws IOException {
        File tmp = File.createTempFile("jccoder.", null);
        tmp.delete();
        tmp.mkdirs();
        return tmp;
    }

    public static boolean clearDirectory(File path, PrintWriter out) {
        if (path.isDirectory() && !FileUtils.delete(path)) {
            FileUtils.log(out, "Can not remove: " + path);
            return false;
        }
        if (!path.mkdirs()) {
            FileUtils.log(out, "Can not create: " + path);
            return false;
        }
        return true;
    }

    public static boolean delete(File file) {
        File[] list;
        boolean retVal = true;
        if (file.isDirectory() && (list = file.listFiles()) != null) {
            for (int i = 0; i < list.length; ++i) {
                retVal = FileUtils.delete(list[i]) && retVal;
            }
        }
        return file.delete() && retVal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InputFileIterator
    implements Iterator<String> {
        public String next;
        public BufferedReader in;

        public InputFileIterator(Reader in) throws IOException {
            this.in = new BufferedReader(in);
            this.next = this.in.readLine();
        }

        public InputFileIterator(InputStream in) throws IOException {
            this(new InputStreamReader(in));
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            String retVal = this.next;
            try {
                this.next = this.in.readLine();
            }
            catch (IOException e) {
                NoSuchElementException nse = new NoSuchElementException("Can not read next element.");
                nse.initCause(e);
                throw nse;
            }
            return retVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing is not supported.");
        }
    }
}

