/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.tools.file;

import com.sun.tck.tools.file.FileUtils;
import com.sun.tck.tools.file.RecursiveIterator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileToStringIterator
implements Iterator<String> {
    private Iterator<File> iterator;
    private File baseDir;

    public FileToStringIterator(File base, Iterator<File> iterator) {
        if (iterator == null) {
            List list = Collections.emptyList();
            this.iterator = list.iterator();
        } else {
            this.iterator = iterator;
        }
        this.baseDir = base;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public String next() {
        File next = this.iterator.next();
        try {
            return this.baseDir == null ? next.getPath() : FileUtils.getRelativePath(this.baseDir, next, null);
        }
        catch (IOException e) {
            throw new NoSuchElementException("Can not convert file to String: " + e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public static Iterable<String> traverseFiles(final File base) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                try {
                    return new FileToStringIterator(base, new RecursiveIterator(base.getAbsolutePath()));
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Can not traverse:" + base, ex);
                }
            }
        };
    }
}

