/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.javatest.services;

import com.sun.tck.j2me.services.LifeCycleAware;
import com.sun.tck.j2me.services.LifeCycleAwareManager;
import com.sun.tck.j2me.services.ServiceFault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class DiscoveryService
implements LifeCycleAware {
    private boolean isRunning = false;
    private LifeCycleAwareManager manager = new LifeCycleAwareManager();
    private Map<String, ServiceFactory> creators = Collections.synchronizedMap(new HashMap());
    private final Map<String, ServiceContainer> registry = new HashMap<String, ServiceContainer>();
    private static DiscoveryService instance;
    private ArrayList<String> inProcess = new ArrayList();
    private static Logger log;

    private DiscoveryService() {
    }

    public String getName() {
        return "DiscoveryService";
    }

    public synchronized void clear(boolean removeCreators) {
        if (removeCreators) {
            this.registry.clear();
            this.creators.clear();
            this.manager.clear();
        } else {
            Iterator<String> i = this.registry.keySet().iterator();
            while (i.hasNext()) {
                String name = i.next();
                ServiceContainer service = this.registry.get(name);
                if (!service.isAutomaticallyCreated()) continue;
                i.remove();
                this.manager.addLifeCycleAware(name, LifeCycleAware.NULL);
            }
        }
    }

    public void registerImplementationName(String name, String implClassName) {
        this.manager.addLifeCycleAware(name, LifeCycleAware.NULL);
        this.creators.put(name, new ServiceFromClassFactory(implClassName));
    }

    public void registerImplementationClass(String name, Class implClass) {
        this.manager.addLifeCycleAware(name, LifeCycleAware.NULL);
        this.creators.put(name, new ServiceFromClassFactory(implClass));
    }

    public void registerImplementation(String name, ServiceFactory impl) {
        this.manager.addLifeCycleAware(name, LifeCycleAware.NULL);
        this.creators.put(name, impl);
    }

    public synchronized void registerService(String name, Object service) {
        this.registerServiceInt(name, new ServiceContainer(service, false));
    }

    public static synchronized DiscoveryService getInstance() {
        if (instance == null) {
            instance = new DiscoveryService();
        }
        return instance;
    }

    public synchronized Object find(String name) throws IllegalArgumentException {
        Object retVal = this.lookupService(name);
        if (retVal == null) {
            try {
                retVal = this.discoveryOrInitService(name);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can not create or init service: " + name, e);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lookupService(String name) {
        ServiceContainer service;
        Map<String, ServiceContainer> map = this.registry;
        synchronized (map) {
            service = this.registry.get(name);
        }
        return service == null ? null : service.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object discoveryOrInitService(String name) throws Exception {
        if (this.inProcess.contains(name)) {
            throw new IllegalArgumentException("Circular dependencies:" + this.inProcess);
        }
        this.inProcess.add(name);
        try {
            Object retVal = this.lookupService(name);
            if (retVal != null) {
                Object object = retVal;
                return object;
            }
            ServiceFactory factory = this.creators.get(name);
            if (factory == null) {
                throw new IllegalArgumentException("Can not find service:" + name);
            }
            retVal = factory.create();
            this.registerServiceInt(name, new ServiceContainer(retVal, true));
            Object object = retVal;
            return object;
        }
        finally {
            this.inProcess.remove(this.inProcess.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerServiceInt(String name, ServiceContainer service) {
        if (this.isRunning) {
            try {
                log.fine("LIFECYCLE-AWARE:DiscoveryService:START:start:name=" + name + " service=" + service + " at " + new Date());
                service.start();
                log.fine("LIFECYCLE-AWARE:DiscoveryService:START:end  :name=" + name + " service=" + service + " at " + new Date());
            }
            catch (ServiceFault ex) {
                throw new IllegalArgumentException("Can not start the service.", ex);
            }
        }
        Map<String, ServiceContainer> ex = this.registry;
        synchronized (ex) {
            this.registry.put(name, service);
        }
        this.manager.addLifeCycleAware(name, service);
        Object node = service.getService();
    }

    public void start() throws ServiceFault {
        this.manager.start();
        this.isRunning = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws ServiceFault {
        this.manager.stop();
        Map<String, ServiceContainer> map = this.registry;
        synchronized (map) {
            Iterator<String> i = this.registry.keySet().iterator();
            while (i.hasNext()) {
                String name = i.next();
                ServiceContainer service = this.registry.get(name);
                log.fine("LIFECYCLE-AWARE:DiscoveryService:STOP:start:name=" + name + " service=" + service + " at " + new Date());
                if (service.isAutomaticallyCreated) {
                    i.remove();
                    Object impl = service.getService();
                }
                log.fine("LIFECYCLE-AWARE:DiscoveryService:STOP:end  :name=" + name + " service=" + service + " at " + new Date());
            }
        }
        this.isRunning = false;
    }

    public String toString() {
        return "Java Card TCK Services";
    }

    static {
        log = Logger.getLogger(DiscoveryService.class.getName());
    }

    private static class ServiceFromClassFactory
    implements ServiceFactory {
        private String name;
        private Class cl;

        public ServiceFromClassFactory(String name) {
            this.name = name;
        }

        public ServiceFromClassFactory(Class cl) {
            this.cl = cl;
        }

        public Object create() throws Exception {
            if (this.cl == null) {
                this.cl = Class.forName(this.name);
            }
            return this.cl.newInstance();
        }

        public boolean isAutomaticallyCreated() {
            return true;
        }
    }

    public static interface ServiceFactory {
        public boolean isAutomaticallyCreated();

        public Object create() throws Exception;
    }

    private static class ServiceContainer
    implements LifeCycleAware {
        private boolean isRunning;
        private Object service;
        private boolean isAutomaticallyCreated;

        public ServiceContainer() {
        }

        public ServiceContainer(Object service, boolean isAutomaticallyCreated) {
            this.service = service;
            this.isAutomaticallyCreated = isAutomaticallyCreated;
        }

        public synchronized Object getService() {
            return this.service;
        }

        public synchronized void start() throws ServiceFault {
            if (!this.isRunning && this.service instanceof LifeCycleAware) {
                ((LifeCycleAware)this.service).start();
                this.isRunning = true;
            }
        }

        public synchronized void stop() throws ServiceFault {
            if (this.isRunning && this.service instanceof LifeCycleAware) {
                ((LifeCycleAware)this.service).stop();
                this.isRunning = false;
            }
        }

        public boolean isAutomaticallyCreated() {
            return this.isAutomaticallyCreated;
        }
    }
}

