/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.javatest;

import com.sun.javatest.Harness;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestRunner;
import com.sun.javatest.TestSuite;
import com.sun.javatest.finder.BinaryTestFinder;
import com.sun.javatest.finder.HTMLTestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.tck.bvtool.terminal.CardStore;
import com.sun.tck.bvtool.terminal.TerminalsPool;
import com.sun.tck.jc.javatest.QueueTestRunner;
import com.sun.tck.jc.javatest.services.BVTDiscoveryUtils;
import com.sun.tck.jc.javatest.services.DiscoveryService;
import com.sun.tck.jc.javatest.services.LoggingService;
import java.io.File;
import java.util.Map;

public class JCTCKTestSuite
extends TestSuite {
    public static final String TEST_SUITE = "testSuite";
    private I18NResourceBundle i18n;

    public JCTCKTestSuite(File root, Map tsInfo, ClassLoader cl) throws TestSuite.Fault {
        super(root, tsInfo, cl);
    }

    public void starting(Harness harness) throws TestSuite.Fault {
        JCTCKTestSuite.registerServices();
        try {
            File tmpDir = harness.getResultTable().getWorkDirectory().getFile("tmp");
            BVTDiscoveryUtils.getLogger().setTmpDir(tmpDir);
            this.initCardStore(harness.getEnv(), tmpDir);
            TerminalsPool.setTestHarness(harness);
        }
        catch (TestSuite.Fault e) {
            BVTDiscoveryUtils.getLogger().logException(TEST_SUITE, e);
            throw e;
        }
        catch (IllegalArgumentException e) {
            BVTDiscoveryUtils.getLogger().logException(TEST_SUITE, e);
            throw new TestSuite.Fault(this.i18n(), e.getMessage());
        }
        catch (Exception ex) {
            BVTDiscoveryUtils.getLogger().logException(TEST_SUITE, ex);
            throw new TestSuite.Fault(this.i18n(), "unexpected.exception", (Object)ex);
        }
        if (!TerminalsPool.isObserverRegistered()) {
            harness.addObserver(TerminalsPool.getTestRunObserver());
        }
        super.starting(harness);
    }

    private static void registerServices() {
        DiscoveryService root = DiscoveryService.getInstance();
        root.registerImplementationClass("card-store", CardStore.class);
        root.registerImplementationClass("logging-service", LoggingService.class);
    }

    private void initCardStore(TestEnvironment env, File tmpDir) throws Exception {
        CardStore store = BVTDiscoveryUtils.getCardStore();
        File stateStore = new File(tmpDir, "card-state-storage");
        stateStore.mkdirs();
        store.setStorageDir(stateStore);
        store.setFormat(this.findFormat(env));
        store.setKeyList(JCTCKTestSuite.join(this.lookup(env, "CardStoreFile", true)));
        store.setPhone(this.lookup(env, "phone", false));
        store.setPhone(this.lookup(env, "ServiceCenterPhone", false));
        store.init();
    }

    private synchronized I18NResourceBundle i18n() {
        if (this.i18n == null) {
            this.i18n = I18NResourceBundle.getBundleForClass(((Object)((Object)this)).getClass());
        }
        return this.i18n;
    }

    private String[] lookup(TestEnvironment env, String key, boolean reportExcp) {
        try {
            return env.lookup(key);
        }
        catch (Exception ex) {
            if (reportExcp) {
                ex.printStackTrace();
            }
            return new String[0];
        }
    }

    private static String join(String[] list) {
        StringBuilder val = new StringBuilder();
        String delim = "";
        for (String str : list) {
            val.append(delim).append(str);
            delim = " ";
        }
        return val.toString();
    }

    private CardStore.Format findFormat(TestEnvironment env) {
        try {
            String[] list = env.lookup("CardStoreFormat");
            return list[0].equals("short_format") ? CardStore.Format.SHORT : CardStore.Format.LONG;
        }
        catch (Exception e) {
            e.printStackTrace();
            return CardStore.Format.LONG;
        }
    }

    protected TestFinder createTestFinder() throws TestSuite.Fault {
        HTMLTestFinder find = null;
        try {
            File f;
            String jtdEntry = (String)this.getTestSuiteInfo().get("testsuite.jtd");
            File jtdFile = jtdEntry == null || jtdEntry.length() == 0 ? new File(new File(this.getRootDir(), "tests"), "testsuite.jtd") : ((f = new File(jtdEntry)).isAbsolute() ? f : new File(this.getRootDir(), f.getPath()));
            if (jtdFile.exists()) {
                BinaryTestFinder btf = new BinaryTestFinder();
                btf.init(new String[]{"-binary", jtdFile.getPath()}, this.getTestsDir(), null);
                find = btf;
            } else {
                HTMLTestFinder htmltf = new HTMLTestFinder();
                htmltf.init(new String[]{"-dirWalk"}, this.getTestsDir(), null);
                find = htmltf;
            }
        }
        catch (TestFinder.Fault f) {
            f.printStackTrace();
        }
        return find;
    }

    public TestRunner createTestRunner() {
        return QueueTestRunner.createTestRunner();
    }
}

