/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.interview.lib;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.Interview;
import com.sun.tck.jc.interview.lib.CompositeInterview;
import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;

public interface Validator {
    public static final String prefix = "com.sun.tck.jc.interview.lib.Validator";
    public static final Validator TrueValidator = new Validator(){

        public String toString() {
            return "com.sun.tck.jc.interview.lib.ValidatorTrueValidator";
        }

        public boolean accept(String tag, Object value, Map map) {
            return true;
        }

        public ErrorQuestion getErrorQuestion(String tag, Object o, Map map) {
            return null;
        }
    };
    public static final Validator NotEmptyListValidator = new Validator(){

        public boolean accept(String tag, Object list, Map map) {
            return list != null && list instanceof Object[] && ((Object[])list).length > 0;
        }

        public String toString() {
            return "com.sun.tck.jc.interview.lib.ValidatorNotEmptyListValidator";
        }

        public ErrorQuestion getErrorQuestion(String tag, Object o, Map map) {
            return null;
        }
    };
    public static final Validator ConfigName = new Validator(){

        public String toString() {
            return "com.sun.tck.jc.interview.lib.ValidatorConfigName";
        }

        public boolean accept(String tag, Object o, Map map) {
            if (o == null || !(o instanceof String) || o.equals("")) {
                return false;
            }
            String s = (String)o;
            if (!Character.isUnicodeIdentifierStart(s.charAt(0))) {
                return false;
            }
            for (int i = 1; i < s.length(); ++i) {
                if (Character.isUnicodeIdentifierPart(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        public ErrorQuestion getErrorQuestion(String tag, Object o, Map map) {
            return null;
        }
    };
    public static final Validator Empty = new Validator(){

        public String toString() {
            return "com.sun.tck.jc.interview.lib.ValidatorEmpty";
        }

        public boolean accept(String tag, Object o, Map map) {
            return o == null || "".equals(o instanceof File ? ((File)o).getPath() : o);
        }

        public ErrorQuestion getErrorQuestion(String tag, Object o, Map map) {
            return null;
        }
    };
    public static final Validator NotEmpty = CompositeInterview.not(Empty);
    public static final Validator isDirectoryValidator = new Validator(){

        public String toString() {
            return "com.sun.tck.jc.interview.lib.ValidatorisDirectoryValidator";
        }

        public boolean accept(String tag, Object o, Map map) {
            return o != null && !o.equals("") && (o instanceof File && ((File)o).isDirectory() || o instanceof String && new File((String)o).isDirectory());
        }

        public ErrorQuestion getErrorQuestion(String tag, Object o, Map map) {
            return null;
        }
    };

    public boolean accept(String var1, Object var2, Map var3);

    public ErrorQuestion getErrorQuestion(String var1, Object var2, Map var3);

    public static class FileListValidator
    implements Validator {
        private ErrorQuestion notFound;
        private String tag;
        private Object files;

        public FileListValidator(Interview interview, String tag) {
            this.tag = tag;
            this.notFound = new ErrorQuestion(interview, tag){

                public Object[] getTextArgs() {
                    return new String[]{FileListValidator.this.createNonExistedFilesList(FileListValidator.this.files)};
                }
            };
        }

        private String createNonExistedFilesList(Object o) {
            if (o instanceof File) {
                return ((File)o).getAbsolutePath();
            }
            if (o == null || !(o instanceof File[])) {
                return null;
            }
            StringBuffer retVal = new StringBuffer();
            File[] list = (File[])o;
            for (int i = 0; i < list.length; ++i) {
                if (list[i].exists()) continue;
                retVal.append(list[i].getAbsolutePath());
                retVal.append(' ');
            }
            return retVal.toString();
        }

        public String toString() {
            return "com.sun.tck.jc.interview.lib.ValidatorFileListValidator." + this.tag;
        }

        public boolean accept(String tag, Object o, Map map) {
            if (o instanceof File) {
                return this.isFileExist((File)o);
            }
            return o instanceof File[] && this.areFilesExist((File[])o);
        }

        private boolean isFileExist(File file) {
            return file.exists();
        }

        private boolean areFilesExist(File[] files) {
            for (int i = 0; i < files.length; ++i) {
                if (this.isFileExist(files[i])) continue;
                return false;
            }
            return true;
        }

        public ErrorQuestion getErrorQuestion(String tag, Object o, Map map) {
            this.files = o;
            return this.accept(tag, o, map) ? null : this.notFound;
        }
    }

    public static class VariableListValidator
    implements Validator {
        private ErrorQuestion formatError;
        private String tag;
        private Object variables;

        public VariableListValidator(Interview interview, String tag) {
            this.tag = tag;
            this.formatError = new ErrorQuestion(interview, tag){

                public Object[] getTextArgs() {
                    return new String[]{VariableListValidator.this.getWrongVariables(VariableListValidator.this.variables)};
                }
            };
        }

        public String toString() {
            return "com.sun.tck.jc.interview.lib.ValidatorVariableListValidator." + this.tag;
        }

        public boolean accept(String tag, Object o, Map map) {
            return o != null && o instanceof String && this.getWrongVariables(o).equals("");
        }

        private String getWrongVariables(Object value) {
            if (value == null || !(value instanceof String)) {
                return "";
            }
            StringBuffer retVal = new StringBuffer();
            StringBuffer current = new StringBuffer();
            boolean isInsideString = false;
            StringTokenizer e = new StringTokenizer((String)value, " \n\t\"", true);
            while (e.hasMoreTokens()) {
                String entry = e.nextToken();
                if (entry.equals("\n")) {
                    return "\n";
                }
                if (entry.equals("\"")) {
                    isInsideString = !isInsideString;
                    current.append('\"');
                    continue;
                }
                if (entry.equals(" ") || entry.equals("\t")) {
                    if (isInsideString) {
                        current.append('\"');
                        continue;
                    }
                    this.processWord(retVal, current);
                    continue;
                }
                current.append(entry);
            }
            if (isInsideString) {
                retVal.append(current.toString());
            } else {
                this.processWord(retVal, current);
            }
            return retVal.toString();
        }

        void processWord(StringBuffer retVal, StringBuffer buff) {
            String word = buff.toString();
            int pos = word.indexOf("=");
            if (buff.length() != 0 && (pos < 0 || pos == word.length() - 1)) {
                retVal.append(word);
                retVal.append(' ');
            }
            buff.delete(0, buff.length());
        }

        public ErrorQuestion getErrorQuestion(String tag, Object o, Map map) {
            this.variables = o;
            return this.formatError;
        }
    }
}

