/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.interview;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.jck.lib.Expr;

class SelecIfFilter
extends TestFilter {
    private TestEnvironment env;

    public SelecIfFilter(TestEnvironment env) {
        if (env == null) {
            System.out.println("WARNING:: 'null' TestEnvironment in 'SelecIfFilter'");
        }
        this.env = env;
    }

    public boolean isSelected(TestDescription td, TestEnvironment env) {
        try {
            String s = td.getParameter("selectIf");
            if (s == null || s.length() == 0 || env == null) {
                return true;
            }
            Expr e = Expr.parse(s);
            return e.evalBoolean(env);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public boolean accepts(TestDescription td) {
        return this.isSelected(td, this.env);
    }

    public boolean accepts(TestDescription td, TestFilter.Observer o) {
        boolean retVal = this.isSelected(td, this.env);
        if (!retVal) {
            o.rejected(td, (TestFilter)this);
        }
        return retVal;
    }

    public String getDescription() {
        return "The filter evaluates 'selectIf' section in TestDescription against to execution environment";
    }

    public String getName() {
        return "'selectIf' TestFilter";
    }

    public String getReason() {
        return "";
    }
}

