/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.tlv;

import com.sun.tck.bvtool.tlv.Encodable;
import com.sun.tck.bvtool.tlv.TLVBuffer;
import com.sun.tck.me.utils.Utils;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface TreeNode {
    public Map<String, ? extends TreeNode> childNodes();

    public Object value();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Value
    implements TreeNode {
        private Object val;
        private String name;

        public Value(String name, Object val) {
            this.name = name;
            this.val = val;
        }

        @Override
        public Map<String, ? extends TreeNode> childNodes() {
            return Collections.emptyMap();
        }

        public String toString() {
            return this.name == null ? String.valueOf(this.val) : this.name + "=" + this.val;
        }

        @Override
        public Object value() {
            return this.val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Data
    implements TreeNode,
    Encodable {
        private byte[] data;
        private String name;

        public Data(String name, int val) {
            this(name, new byte[]{(byte)val});
        }

        public Data(String name, byte[] data) {
            this(name, data, 0, data.length);
        }

        public Data(String name, byte[] data, int offset, int length) {
            this.name = name;
            this.data = new byte[length];
            System.arraycopy(data, offset, this.data, 0, length);
        }

        @Override
        public Map<String, ? extends TreeNode> childNodes() {
            return Collections.emptyMap();
        }

        @Override
        public void encode(TLVBuffer buff) {
            buff.write(this.data);
        }

        public String toString() {
            return (this.name != null ? this.name + "=" : "") + Utils.canonize(this.data);
        }

        @Override
        public Object value() {
            return this.data;
        }
    }
}

