/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.tlv;

import com.sun.tck.bvtool.tlv.Encodable;
import com.sun.tck.bvtool.tlv.EncodingException;
import com.sun.tck.bvtool.tlv.TLV;
import com.sun.tck.bvtool.tlv.TLVBuffer;
import com.sun.tck.bvtool.tlv.TLVPrototypeFactory;

public class TLVUtils {
    public static long lookupTag(TLVBuffer in) throws EncodingException {
        TLVBuffer.Position pos = in.createPosition();
        long retVal = TLVUtils.readTag(in);
        in.setPosTo(pos.pos());
        return retVal;
    }

    public static long readTag(TLVBuffer in) throws EncodingException {
        int c = in.read();
        if ((c & 0x1F) == 31) {
            long l = c & 0xFF;
            do {
                c = in.read();
                l <<= 8;
                l |= (long)(c & 0xFF);
            } while ((c & 0x80) != 0);
            return l;
        }
        return c;
    }

    public static boolean isConstructed(long tag) {
        boolean retVal;
        do {
            boolean bl = retVal = (tag & 0x20L) != 0L;
        } while ((tag >>>= 8) != 0L);
        return retVal;
    }

    public static int readLength(TLVBuffer in) throws EncodingException {
        int current = in.read() & 0xFF;
        int length = 0;
        if ((current & 0x80) != 0) {
            current &= 0x7F;
            for (int i = 0; i < current; ++i) {
                length = length << 8 | in.read() & 0xFF;
            }
        } else {
            length = current;
        }
        return length;
    }

    public static byte[] parse(long l) {
        return TLVUtils.parse(l, -1);
    }

    public static byte[] parse(long l, int length) {
        if (length <= 0) {
            long curr = l;
            length = 0;
            while (curr != 0L) {
                curr >>= 8;
                ++length;
            }
            length = length == 0 ? 1 : length;
        }
        byte[] retVal = new byte[length];
        for (int i = length - 1; i >= 0; --i) {
            retVal[i] = (byte)l;
            l >>= 8;
        }
        return retVal;
    }

    public static byte[] encode(Encodable enc) throws EncodingException {
        TLVBuffer buff = new TLVBuffer(10240);
        enc.encode(buff);
        return TLVUtils.toByteArray(buff);
    }

    public static String toBinaryString(long value, int length, String delim) {
        StringBuilder buff = new StringBuilder();
        String dlm = "";
        for (int i = 0; i < length; ++i) {
            buff.append(dlm);
            String val = Integer.toBinaryString((int)(value & 0xFFL));
            for (int j = 8 - val.length(); j > 0; --j) {
                buff.append('0');
            }
            buff.append(val);
            dlm = delim;
        }
        return buff.toString();
    }

    public static void encodeIntBy7Bits(TLVBuffer buff, long current) {
        long t = current;
        int length = 0;
        do {
            ++length;
        } while ((t >>>= 7) != 0L);
        int shift = length * 7;
        while (shift > 0) {
            int b = (shift -= 7) == 0 ? 0 : -128;
            b = (byte)((long)b | current >>> shift & 0x7FL);
            buff.write(b);
        }
    }

    public static void writeLength(TLVBuffer lengthBuff, int length) throws EncodingException {
        if (length <= 127) {
            lengthBuff.write(length);
        } else {
            int count = 0;
            int current = length;
            while (current != 0) {
                current >>= 8;
                ++count;
            }
            lengthBuff.expand(count);
            lengthBuff.write(count | 0x80);
            for (int i = count * 8 - 8; i >= 0; i -= 8) {
                lengthBuff.write(length >> i);
            }
        }
    }

    public static TLV parse(TLVPrototypeFactory factory, TLVBuffer in) throws Exception {
        TLV retVal = factory.create(TLVUtils.lookupTag(in));
        retVal.decode(factory, in);
        return retVal;
    }

    public static byte[] toByteArray(TLVBuffer buff) {
        return TLVUtils.trim(buff.getBuffer(), buff.getPos());
    }

    private static byte[] trim(byte[] data, int newLength) {
        if (data.length == newLength) {
            return data;
        }
        byte[] retVal = new byte[newLength];
        System.arraycopy(data, 0, retVal, 0, Math.min(data.length, newLength));
        return retVal;
    }
}

