/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.tlv;

import com.sun.tck.bvtool.tlv.EncodingException;
import com.sun.tck.me.utils.Utils;
import java.util.ArrayList;

public class TLVBuffer {
    private Ref data;
    private Position counter;
    private ArrayList<Position> pointers = new ArrayList();
    private Position start;
    private Position end;

    public TLVBuffer(String string) {
        this(Utils.parse(string));
    }

    public TLVBuffer(int length) {
        this(new byte[length], 0, length);
    }

    public final Position createPosition() {
        return this.createPosition(this.getPos());
    }

    public final Position createPosition(int pos) {
        Position retVal = new Position(this, pos);
        this.pointers.add(retVal);
        return retVal;
    }

    public TLVBuffer(byte[] data) {
        this(data, 0, data.length);
    }

    private TLVBuffer(TLVBuffer parent, Position start, Position end) throws EncodingException {
        this.data = parent.data;
        this.start = start;
        this.end = end;
        this.pointers = parent.pointers;
        this.check(parent.getPos());
        this.counter = this.createPosition(parent.getPos());
    }

    public TLVBuffer(byte[] data, int offset, int length) {
        this.data = new Ref(data, offset);
        this.start = this.createPosition(offset);
        this.end = this.createPosition(offset + length);
        this.counter = this.createPosition(offset);
    }

    public byte[] getBuffer() {
        return this.data.ref;
    }

    public int getPos() {
        return this.counter.pos;
    }

    public int start() {
        return this.start.pos;
    }

    public int end() {
        return this.end.pos;
    }

    public void reset() throws EncodingException {
        this.setPosTo(this.start());
    }

    public TLVBuffer createChild(Position start, int length) throws EncodingException {
        TLVBuffer retVal = new TLVBuffer(this, start, this.createPosition(start.pos + length));
        this.counter.pos = retVal.end();
        return retVal;
    }

    public TLVBuffer createSharedBlock(Position start) throws EncodingException {
        return start.pos == this.start() ? this : new TLVBuffer(this, start, this.end);
    }

    public TLVBuffer createChild(int length) throws EncodingException {
        return this.createChild(this.createPosition(), length);
    }

    public void guarantee(int upperPos) {
        this.data.setPos(upperPos);
        if (upperPos <= this.data.ref.length) {
            return;
        }
        int newLength = Math.max((int)((double)this.data.ref.length * 1.5), upperPos + 128);
        byte[] increased = new byte[newLength];
        System.arraycopy(this.data.ref, 0, increased, 0, this.data.ref.length);
        this.data.ref = increased;
    }

    public int write(int b) {
        this.guarantee(this.counter.pos + 1);
        this.data.ref[((Position)this.counter).pos++] = (byte)b;
        return this.counter.pos;
    }

    public int write(byte[] data) {
        return this.write(data, 0, data.length);
    }

    public int write(byte[] data, int offset, int length) {
        this.guarantee(this.counter.pos + length);
        System.arraycopy(data, offset, this.data.ref, this.counter.pos, length);
        this.counter.pos += length;
        return this.counter.pos;
    }

    public int write(long data, int length) {
        this.guarantee(this.counter.pos + length);
        for (int i = length - 1; i >= 0; --i) {
            this.data.ref[((Position)this.counter).pos + i] = (byte)data;
            data >>= 8;
        }
        this.counter.pos += length;
        return this.counter.pos;
    }

    public int skip(int length) throws EncodingException {
        this.guarantee(this.getPos() + length);
        this.check(this.getPos() + length);
        this.counter.pos += length;
        return this.counter.pos;
    }

    private void check(int pos) throws EncodingException {
        if (pos < this.start.pos || pos > this.end.pos) {
            throw new EncodingException(pos + " is not in range from " + this.start.pos + " inclusive to " + this.end.pos + " exclusive");
        }
    }

    public void setPosTo(int pos) throws EncodingException {
        this.check(pos);
        this.counter.pos = pos;
    }

    public void expand(int increment) throws EncodingException {
        if (increment < 0) {
            throw new EncodingException("Increment should be positive");
        }
        this.guarantee(this.data.upperBound + increment);
        int at = this.end.pos;
        System.arraycopy(this.data.ref, at, this.data.ref, at + increment, this.data.ref.length - at - increment);
        for (Position p : this.pointers) {
            if (p.pos < at) continue;
            p.pos += increment;
        }
    }

    public byte[] readArray(int length) throws EncodingException {
        this.check(this.getPos() + length);
        byte[] retVal = new byte[length];
        System.arraycopy(this.data.ref, this.counter.pos, retVal, 0, length);
        this.counter.pos += length;
        return retVal;
    }

    public int read() throws EncodingException {
        this.check(this.getPos());
        int retVal = 0xFF & this.data.ref[this.counter.pos++];
        return retVal;
    }

    public long read(int length) throws EncodingException {
        this.check(this.getPos() + length);
        long retVal = 0L;
        for (int i = 0; i < length; ++i) {
            retVal = retVal << 8 | (long)this.read();
        }
        return retVal;
    }

    public int available() {
        return this.end() - this.counter.pos;
    }

    public String toString() {
        return "TLVBuffer:" + Utils.canonize(this.data.ref, this.start(), Math.min(65, this.end() - this.start()));
    }

    public static class Position {
        private int pos;
        public final TLVBuffer buff;

        public Position(TLVBuffer buff, int pos) {
            this.buff = buff;
            this.pos = pos;
        }

        public int pos() {
            return this.pos;
        }
    }

    private static class Ref {
        public byte[] ref;
        public int upperBound;

        public Ref(byte[] ref, int upperBound) {
            this.ref = ref;
        }

        public void setPos(int val) {
            this.upperBound = Math.max(this.upperBound, val);
        }
    }
}

