/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.tlv;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class ConstantBundle {
    private HashMap<Integer, String> map = new HashMap();
    private int mask = 255;
    private boolean addRequired = true;

    private int createKey(int constant) {
        return constant & this.mask;
    }

    public ConstantBundle() {
        this(true, null);
    }

    public ConstantBundle(boolean addRequired, Class cl) {
        this.addRequired = addRequired;
        this.registerConstants(cl);
    }

    public void setAddRequired(boolean addRequired) {
        this.addRequired = addRequired;
    }

    public String find(int constant) {
        String retVal = this.map.get(new Integer(constant = this.createKey(constant)));
        return retVal == null ? Integer.toHexString(constant) : retVal;
    }

    private boolean isNumber(Class type) {
        return type.equals(Integer.TYPE) || type.equals(Byte.TYPE) || type.equals(Short.TYPE);
    }

    private void registerConstants(Class cl) {
        if (cl == null) {
            return;
        }
        for (Field f : cl.getFields()) {
            int mod = f.getModifiers();
            Class<?> type = f.getType();
            if (!Modifier.isFinal(mod) || !Modifier.isStatic(mod) || !this.isNumber(type)) continue;
            try {
                this.register(f.getInt(null), f.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void register(int constant, String name) {
        constant = this.createKey(constant);
        String hex = Integer.toHexString(constant);
        this.map.put(new Integer(constant), name + "(0x" + hex + ")");
        if (this.addRequired) {
            int req = constant | 0x80;
            this.map.put(new Integer(req), name + "(0x" + Integer.toHexString(req) + " response-required-bit" + ")");
        }
    }
}

