/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.terminal;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.CommunicationService;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.javacard.cjck.userinterface.FrameworkException;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.javacard.referenceimpl.Logger;
import com.sun.tck.bvtool.gp.GPOverETSICardService;
import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import com.sun.tck.bvtool.terminal.TerminalsPool;
import com.sun.tck.jc.javatest.services.BVTDiscoveryUtils;
import com.sun.tck.jc.javatest.services.LoggingService;
import com.sun.tck.me.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TerminalCardService
implements CJCKCardService {
    private StatefulCardTerminal terminal;
    private CJCKCardService service;
    protected Logger log;
    protected Properties serviceProperties = new Properties();
    private static final long PACKAGE_AID_LENGTH_POS = 12L;
    private static byte[] cleanUpApdu = new byte[]{-128, 32, -1, 0, 1, -1};

    public TerminalCardService(CJCKCardService service) {
        this.service = service;
    }

    public void setCardTerminal(StatefulCardTerminal terminal) {
        this.terminal = terminal;
        if (this.service != null) {
            this.service.setCardTerminal(terminal);
        }
    }

    public StatefulCardTerminal getCardTerminal() {
        return this.terminal;
    }

    public CJCKCardService getBaseCardService() {
        return this.service;
    }

    public CommunicationService getCommunicationService(int iface) throws CardProxyException {
        return this.service.getCommunicationService(iface);
    }

    public String convertPackage(String packageName, AppletID packageAid, int majorVersion, int minorVersion, String classRootDir, String exportRootDir, boolean isExportMap, String outputRootDir, AppletProperties[] apa) throws FrameworkException {
        throw new UnsupportedOperationException(I18n.getString("cardservice.unsupported.operation"));
    }

    public boolean deleteAppletInstances(AppletProperties[] applets) throws CardProxyException {
        return this.service.deleteAppletInstances(applets);
    }

    public boolean deletePackage(AppletID packageID, String packageName) throws CardProxyException {
        return this.service.deletePackage(packageID, packageName);
    }

    public boolean deletePackageAndInstances(AppletID packageID, String packageName) throws CardProxyException {
        return this.service.deletePackageAndInstances(packageID, packageName);
    }

    public Hashtable getProperties() {
        return this.service.getProperties();
    }

    public void init(String[] args, PrintWriter out, PrintWriter ref) {
        this.service.init(args, out, ref);
        this.log = new Logger(0, out, ref);
    }

    public boolean installCAPFile(AppletProperties[] appletPropertiesArray, String aCAPFileName, String outputDir) throws CardProxyException {
        return this.service.installCAPFile(appletPropertiesArray, aCAPFileName, outputDir);
    }

    public boolean loadCapFileApplets(String[] capfiles, AppletProperties[] appletProperties, String outputRootDir) throws DeploymentException {
        throw new UnsupportedOperationException(I18n.getString("cardservice.unsupported.operation"));
    }

    public boolean loadClassFileApplets(String[] packageNames, AppletProperties[] appletProperties, String classRootDir, String outputRootDir) throws DeploymentException {
        throw new UnsupportedOperationException(I18n.getString("cardservice.unsupported.operation"));
    }

    public void powerDown() throws CardProxyException {
        this.service.powerDown();
    }

    public void powerUp() throws CardProxyException {
        this.service.powerUp();
    }

    public void reset() throws CardProxyException {
        this.service.reset();
    }

    public ResponseAPDU sendAPDU(CommandAPDU capdu) throws CardProxyException {
        return this.service.sendAPDU(capdu);
    }

    public void startTest(String workingDir, int numberOfExecutions) throws CardProxyException {
        this.service.startTest(workingDir, numberOfExecutions);
    }

    public void deleteInstalledPackages() throws CardProxyException {
        boolean status = this.deleteInstalledPackagesInternally(this.getInstalledPackages());
        if (status) {
            return;
        }
        BVTDiscoveryUtils.getLogger().log(this.getClass().getName(), "Can not clean up the card", new Object[0]);
        AppletID[] list = this.getInstalledPackages();
        Card card = this.terminal.getInsertedCard();
        for (int i = list.length - 1; i >= 0; --i) {
            for (String appletAid : card.getInstalledApplets(list[i])) {
                this.cleanUpApplet(Utils.parse(appletAid));
            }
        }
        this.deleteInstalledPackagesInternally(list);
    }

    private void cleanUpApplet(byte[] appletAid) {
        try {
            CommandAPDU select = new CommandAPDU(0, -92, 4, 0, appletAid, 127);
            ResponseAPDU answer = this.service.sendAPDU(select);
            if ((answer.sw() & 0x9000) == 36864) {
                CommandAPDU cmd = new CommandAPDU(cleanUpApdu);
                ResponseAPDU responseAPDU = this.service.sendAPDU(cmd);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private AppletID[] getInstalledPackages() {
        Card card = this.terminal.getInsertedCard();
        List<AppletID> list = card.getInstalledPackages();
        AppletID[] retVal = new AppletID[list.size()];
        int pos = 0;
        for (AppletID aid : list) {
            retVal[pos++] = aid;
        }
        return retVal;
    }

    private boolean deleteInstalledPackagesInternally(AppletID[] aids) throws CardProxyException {
        this.reset();
        boolean retVal = true;
        for (int i = aids.length - 1; i >= 0; --i) {
            AppletID aid = aids[i];
            try {
                retVal = this.deletePackageAndInstances(aid, aid.toString()) && retVal;
                continue;
            }
            catch (Exception e) {
                BVTDiscoveryUtils.getLogger().logException(this.getClass().getName(), e);
            }
        }
        return retVal;
    }

    public void stopTest() throws CardProxyException {
        this.service.stopTest();
    }

    public void releaseTerminal() {
        TerminalsPool.releaseTerminal(this.terminal);
    }

    public boolean initializeCardService() {
        LoggingService log = BVTDiscoveryUtils.getLogger();
        log.log("TerminalCardService", "In initializeCardService() for {0}", this.terminal);
        if (this.service != null && this.service instanceof GPOverETSICardService) {
            try {
                ((GPOverETSICardService)this.service).setCard(this.terminal.getInsertedCard());
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return true;
    }

    public StatefulCardTerminal.State getState() {
        return this.terminal.getState();
    }

    public String getTerminalName() {
        return this.terminal.getLabel();
    }

    public void setTerminalName(String name) {
        this.terminal.setLabel(name);
    }

    public String toString() {
        return "TerminalCardService for terminal: " + this.terminal;
    }

    public void setState(StatefulCardTerminal.State state) {
        this.terminal.setState(state);
        LoggingService log = BVTDiscoveryUtils.getLogger();
        log.log("TerminalCardService", "CardService state set to {0}", new Object[]{state});
    }

    private static AppletID getPackageID(String capFileName) throws DeploymentException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(capFileName);
        }
        catch (IOException ex) {
            throw new DeploymentException(I18n.getString("no.cap.file", capFileName));
        }
        ZipEntry headerEntry = null;
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().endsWith("Header.cap")) continue;
            headerEntry = entry;
            break;
        }
        AppletID aid = null;
        InputStream in = null;
        if (headerEntry != null) {
            try {
                in = zip.getInputStream(headerEntry);
                in.skip(12L);
                int packageAidLength = in.read();
                byte[] aidBytes = new byte[packageAidLength];
                in.read(aidBytes, 0, packageAidLength);
                aid = new AppletID(aidBytes);
            }
            catch (IOException ex) {
                throw new DeploymentException(I18n.getString("error.reading.package.aid", capFileName));
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        return aid;
    }
}

