/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.terminal;

import com.sun.javacard.cjck.userinterface.FatalException;
import com.sun.tck.bvtool.sms.Phone;
import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.bvtool.terminal.CardState;
import com.sun.tck.me.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.util.LinkedHashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CardStore {
    public static final int NUMBER_OF_GSM_KEYS = 4;
    public static final int ICCID_OFFSET = 1;
    public static final int DEFAULT_GSM_KEYS_OFFSET = 14;
    private File stateStorage;
    private Format format = Format.LONG;
    private Phone phone;
    private Phone serviceCenterPhone;
    private LinkedHashMap<String, Card> cards = new LinkedHashMap();
    private File keyList;

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setPhone(String[] params) {
        this.phone = this.parsePhone(params);
    }

    public void setServiceCenterPhone(String[] params) {
        this.serviceCenterPhone = this.parsePhone(params);
    }

    private Phone parsePhone(String[] params) {
        try {
            switch (params.length) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new Phone(Utils.parse(params[0]));
                }
                case 2: {
                    return new Phone(Integer.parseInt(params[1]), Utils.parse(params[0]));
                }
            }
            return new Phone(Integer.parseInt(params[1]), Integer.parseInt(params[2]), Utils.parse(params[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setKeyList(String name) throws Exception {
        this.keyList = new File(name);
    }

    public void init() throws Exception {
        File defList = new File("keys.txt");
        if (this.keyList == null && defList.exists()) {
            this.keyList = defList;
        }
        this.setKeyList(new FileInputStream(this.keyList));
        if (this.cards.isEmpty()) {
            throw new IllegalArgumentException("key.list.is.empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyList(InputStream strm) throws Exception {
        BufferedReader in = new BufferedReader(new InputStreamReader(strm));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String[] keys = line.split("[\n\t ]+");
                int iccidOffset = this.format.getICCIDOffset();
                String iccid = CardStore.canonizeICCID(keys[iccidOffset]);
                Card card = new Card(CardState.restore(this.stateStorage, iccid), iccid);
                this.configure(card, keys);
                this.cards.put(iccid, card);
            }
        }
        finally {
            in.close();
        }
    }

    private void configure(Card card, String[] keys) throws GeneralSecurityException {
        int length = this.format.getKeyCount(keys.length);
        for (int id = 1; id <= length; ++id) {
            card.addKey(id, this.format.getKID(keys, id), this.format.getKIC(keys, id));
        }
    }

    private static String canonizeICCID(String st) {
        if (st.length() < 20) {
            return st.toLowerCase();
        }
        return st.substring(0, st.length() - 1).toLowerCase();
    }

    public Card findCard(String id) throws FatalException {
        Card retVal = null;
        id = CardStore.canonizeICCID(id);
        for (String iccid : this.cards.keySet()) {
            if (!iccid.endsWith(id)) continue;
            if (retVal != null) {
                throw new FatalException(FatalException.Scope.Card, "CONFLICT: " + retVal.state.iccid + " and " + iccid);
            }
            retVal = this.cards.get(iccid);
        }
        if (retVal == null) {
            throw new FatalException(FatalException.Scope.Card, "can not find key for " + id);
        }
        if (this.phone != null) {
            retVal.state.phone = this.phone;
        }
        if (this.serviceCenterPhone != null) {
            retVal.state.serviceSenterPhone = this.serviceCenterPhone;
        }
        return retVal;
    }

    public Set<String> getCardIDs() {
        return this.cards.keySet();
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder("(CardStore");
        for (String iccid : this.cards.keySet()) {
            retVal.append("\n    ").append(iccid).append("=").append(this.cards.get(iccid));
        }
        retVal.append(")");
        return retVal.toString();
    }

    public void setStorageDir(File stateStorage) {
        this.stateStorage = stateStorage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        LONG(1, 14, 3),
        SHORT(0, 1, 2);

        private int iccidOffset;
        private int gsmKeysOffset;
        private int keysPerVersion;

        private Format(int iccidOffset, int gsmKeysOffset, int keysPerVersion) {
            this.iccidOffset = iccidOffset;
            this.gsmKeysOffset = gsmKeysOffset;
            this.keysPerVersion = keysPerVersion;
        }

        public int getICCIDOffset() {
            return this.iccidOffset;
        }

        public String getKID(String[] keys, int id) {
            return keys[this.gsmKeysOffset + (id - 1) * this.keysPerVersion + 1];
        }

        public String getKIC(String[] keys, int id) {
            return keys[this.gsmKeysOffset + (id - 1) * this.keysPerVersion];
        }

        public int getKeyCount(int length) {
            return (length - this.gsmKeysOffset) / this.keysPerVersion;
        }
    }
}

