/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.terminal;

import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import java.util.Observable;
import java.util.Observer;
import javax.smartcardio.CardException;

public class CardPresenceNotifier
extends Observable
implements Runnable {
    private StatefulCardTerminal terminal;
    private boolean wasCardPresent;
    private boolean isStopped;

    public CardPresenceNotifier(StatefulCardTerminal terminal) throws CardException {
        this.terminal = terminal;
        this.wasCardPresent = terminal.isCardPresent();
    }

    public StatefulCardTerminal getTerminal() {
        return this.terminal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addObserver(Observer o) {
        CardPresenceNotifier cardPresenceNotifier = this;
        synchronized (cardPresenceNotifier) {
            super.addObserver(o);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CardPresenceNotifier cardPresenceNotifier = this;
        synchronized (cardPresenceNotifier) {
            this.isStopped = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isStopped) {
            try {
                if (this.countObservers() == 0) {
                    CardPresenceNotifier cardPresenceNotifier = this;
                    synchronized (cardPresenceNotifier) {
                        this.wait(10000L);
                    }
                } else {
                    boolean isCardPresent = this.terminal.isCardPresent();
                    if (isCardPresent != this.wasCardPresent) {
                        this.setChanged();
                        if (isCardPresent) {
                            this.notifyObservers((Object)CardEvent.CARD_INSERTED);
                        } else {
                            this.notifyObservers((Object)CardEvent.CARD_REMOVED);
                        }
                        this.wasCardPresent = isCardPresent;
                    }
                }
                Thread.yield();
            }
            catch (InterruptedException e) {
                return;
            }
            catch (CardException ex) {
                this.terminal.setState(StatefulCardTerminal.State.INVALID);
                this.setChanged();
                this.notifyObservers((Object)CardEvent.INVALID_STATE);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CardEvent {
        CARD_INSERTED,
        CARD_REMOVED,
        INVALID_STATE;

    }
}

