/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.terminal;

import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.FatalException;
import com.sun.tck.bvtool.security.KeyDescr;
import com.sun.tck.bvtool.security.KeyType;
import com.sun.tck.bvtool.sms.Phone;
import com.sun.tck.bvtool.terminal.CardState;
import com.sun.tck.me.utils.User;
import com.sun.tck.me.utils.Utils;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Card {
    public static int MAX_COUNTER = 65535;
    public static final int DEFAULT_KEY = 1;
    static final int NUMBER_OF_KEYS = 16;
    public static final int NUMBER_OF_GSM_KEYS = 5;
    public int lowCounter;
    public int highCounter;
    public int counterStep = 16;
    public boolean isInitalized;
    private User user = new User(User.NOT_INTERACTIVE);
    CardState state;
    private static SecurityLevel[] levels = new SecurityLevel[]{new SecurityLevel(CounterMode.NO_COUNTER, false), new SecurityLevel(CounterMode.NO_COUNTER, true), new SecurityLevel(CounterMode.NO_CHECKING, false), new SecurityLevel(CounterMode.NO_CHECKING, true), new SecurityLevel(CounterMode.PROCESS_IF_NEXT, false), new SecurityLevel(CounterMode.PROCESS_IF_NEXT, true), new SecurityLevel(CounterMode.PROCESS_IF_HIGHER, false), new SecurityLevel(CounterMode.PROCESS_IF_HIGHER, true)};

    public void notifyRegisteredCapFile(AppletID packageID, AppletProperties[] applets) {
        String aidRep = Utils.canonize(packageID.getBytes());
        if (!this.state.installedCapFiles.containsKey(aidRep)) {
            this.state.installedCapFiles.put(aidRep, Card.toStringList(applets));
        }
        this.state.flush();
    }

    public ArrayList<String> getInstalledApplets(AppletID packAID) {
        ArrayList retVal = this.state.installedCapFiles.get(Utils.canonize(packAID.getBytes()));
        return retVal == null ? new ArrayList() : retVal;
    }

    public List<AppletID> getInstalledPackages() {
        ArrayList<AppletID> retVal = new ArrayList<AppletID>();
        for (String key : this.state.installedCapFiles.keySet()) {
            retVal.add(new AppletID(Utils.parse(key)));
        }
        return retVal;
    }

    public void notifyDeletedCapFile(AppletID aid) {
        String aidRep = Utils.canonize(aid.getBytes());
        if (this.state.installedCapFiles.containsKey(aidRep)) {
            this.state.installedCapFiles.remove(aidRep);
        }
        this.state.flush();
    }

    public void setUser(User user) {
        this.user = user != null ? user : new User(User.NOT_INTERACTIVE);
    }

    public void logCardInfo() {
        int cntr = this.getCounter();
        this.user.log("COUNTER=" + cntr + "(0x" + Integer.toHexString(cntr) + ")");
        this.user.log("SECURITY-LEVEL=" + levels[this.state.currentSecurityLevel]);
        this.user.log("KEY-VERSION=" + this.state.keyVersion);
    }

    Card() {
        this.state = new CardState();
        this.state.keyVersion = 1;
    }

    public Card(CardState state, String iccid, int keyVersion, String KID, String KIC) throws GeneralSecurityException {
        this.state = state == null ? new CardState() : state;
        this.state.iccid = iccid;
        this.state.keyVersion = keyVersion;
        this.addKey(state.keyVersion, KID, KIC);
    }

    public static KeyType detect(String key) {
        if (key.length() > 32) {
            return KeyType.TRIPLE_DES_CBC;
        }
        if (key.length() > 16) {
            return KeyType.TRIPLE_DES_CBC_2_OF_3;
        }
        return KeyType.DES_CBC;
    }

    public Card(CardState state, String iccid) {
        this.state = state == null ? new CardState() : state;
        this.state.keyVersion = 1;
        this.state.iccid = iccid;
    }

    public void reset() {
        this.state.reset();
    }

    public int changeKeyVersion() throws FatalException {
        int newKeyVersion = this.state.keyVersion + 1;
        if (newKeyVersion >= 5 || this.state.keys[newKeyVersion] == null) {
            throw new FatalException(FatalException.Scope.Card, "Number of the supported keys has been exceed");
        }
        ++this.state.keyVersion;
        this.lowCounter = 0;
        this.highCounter = 65520;
        this.user.log("Change-key-version-to:" + this.state.keyVersion);
        return this.state.keyVersion;
    }

    public void increaseCounter() throws FatalException {
        CounterMode mode = Card.levels[this.state.currentSecurityLevel].counterMode;
        if (mode == CounterMode.PROCESS_IF_HIGHER) {
            this.lowCounter = this.getCounter();
            this.setCounter(this.lowCounter + this.counterStep);
            return;
        }
        if (this.highCounter == 0) {
            this.highCounter = MAX_COUNTER + 1;
        }
        this.lowCounter = this.getCounter();
        this.checkCountersRange();
        int newCounter = (this.lowCounter + this.highCounter) / 2 - 1;
        if (newCounter == this.getCounter()) {
            ++newCounter;
        }
        this.setCounter(newCounter);
        this.user.log("Increase-Counter-to:" + (newCounter + 1));
    }

    public void decreaseCounter() throws FatalException {
        this.highCounter = this.getCounter();
        this.checkCountersRange();
        int newCounter = (this.lowCounter + this.highCounter) / 2 - 1;
        if (newCounter == this.getCounter()) {
            --newCounter;
        }
        this.setCounter(newCounter);
        this.user.log("Decrease-Counter-to:" + (newCounter + 1));
    }

    private void checkCountersRange() throws FatalException {
        if (this.highCounter - this.lowCounter < 2) {
            this.changeKeyVersion();
        }
    }

    public Phone getPhone() {
        return this.state.phone;
    }

    public Phone getServiceCenterPhone() {
        return this.state.phone;
    }

    public void increaseSecurityLevel() throws FatalException {
        ++this.state.currentSecurityLevel;
        if (this.state.currentSecurityLevel >= levels.length) {
            throw new FatalException(FatalException.Scope.Card, "There is no higher security level");
        }
        if (this.user != null) {
            this.user.log("Increasing security level to #" + this.state.currentSecurityLevel + "=" + levels[this.state.currentSecurityLevel]);
        }
    }

    public void setCounter(int counter) {
        this.state.keys[this.state.keyVersion].counter = counter;
    }

    public int getCounter() {
        return this.state.keys[this.state.keyVersion].counter;
    }

    public void confirmCounter() throws FatalException {
        if (this.state.keys[this.state.keyVersion].counter >= MAX_COUNTER) {
            this.changeKeyVersion();
        }
        this.state.keys[this.state.keyVersion].counter++;
    }

    public boolean isReplyCiphered() {
        return levels[this.state.currentSecurityLevel].isReplyCiphered;
    }

    public final void addKey(int keyId, String KID, String KIC) throws GeneralSecurityException {
        this.addKey(keyId, Card.detect(KID), KID, Card.detect(KIC), KIC);
    }

    public final void addKey(int keyId, KeyType kidType, String KID, KeyType kicType, String KIC) throws GeneralSecurityException {
        KeyDescr kid = KID == null ? null : new KeyDescr(kidType, keyId, Utils.parse(KID));
        KeyDescr kic = KIC == null ? null : new KeyDescr(kidType, keyId, Utils.parse(KIC));
        int index = (keyId & 0xF0) == 0 ? keyId : keyId >> 4 & 0xF;
        int counter = this.state.keys[index] == null ? 1 : this.state.keys[index].counter;
        this.state.keys[index] = new Pair(kid, kic, counter);
    }

    public KeyDescr getKID() {
        return this.getKID(this.state.keyVersion << 4);
    }

    public KeyDescr getKID(int KID) {
        Pair pair = this.state.keys[KID = 0xF & KID >> 4];
        return pair == null ? null : pair.KID;
    }

    public KeyDescr getKIC() {
        return this.getKIC(this.state.keyVersion << 4);
    }

    public KeyDescr getKIC(int KIC) {
        if (!Card.levels[this.state.currentSecurityLevel].doEncryption) {
            return null;
        }
        Pair pair = this.state.keys[KIC = 0xF & KIC >> 4];
        return pair == null ? null : pair.KIC;
    }

    public void setKeyVersion(int version) {
        this.state.keyVersion = version;
    }

    public void init() throws Exception {
    }

    public void setSecurityLevel(int level) {
        this.state.currentSecurityLevel = level;
    }

    public short encodeSPI() {
        byte first = (byte)(Card.levels[this.state.currentSecurityLevel].counterMode.code() << 3);
        KeyDescr key = this.getKID();
        first = (byte)(first | (key != null ? key.checksum.getCode() : (byte)0));
        key = this.getKIC();
        first = (byte)(first | (key != null ? 4 : 0));
        byte second = 0;
        second = (byte)(second | levels[this.state.currentSecurityLevel].replyMode.code());
        second = (byte)(second | levels[this.state.currentSecurityLevel].replySignature.code() << 2);
        second = (byte)(second | (this.isReplyCiphered() ? 16 : 0));
        second = (byte)(second | 1);
        return (short)(first << 8 | 0x21);
    }

    public String toString() {
        return "(SESSION security-level#" + this.state.currentSecurityLevel + "=" + levels[this.state.currentSecurityLevel] + "\n    ICCID=" + this.state.iccid + "\n    counter=" + this.state.keys[this.state.keyVersion].counter + "\n    KID=" + this.getKID() + "\n    KIC=" + this.getKIC() + "\n    SPI=" + Integer.toBinaryString(this.encodeSPI()) + ")";
    }

    public void flush() {
        this.state.flush();
    }

    private static ArrayList<String> toStringList(AppletProperties[] list) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (AppletProperties applet : list) {
            retVal.add(Utils.canonize(applet.getAID().getBytes()));
        }
        return retVal;
    }

    private static class SecurityLevel {
        private ReplyMode replyMode = ReplyMode.REQUIRED;
        private SignatureMode replySignature = SignatureMode.CryptographicChecksum;
        private boolean isReplyCiphered = false;
        boolean doEncryption;
        CounterMode counterMode;

        public SecurityLevel(CounterMode counterMode, boolean doEncryption) {
            this.doEncryption = doEncryption;
            this.counterMode = counterMode;
        }

        public String toString() {
            return "(SecurityLevel doEncryption=" + this.doEncryption + " counterMode=" + (Object)((Object)this.counterMode) + ')';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SignatureMode {
        NONE(0),
        RedundancyCheck(1),
        CryptographicChecksum(2),
        DigitalSignature(3);

        private byte code;

        public byte code() {
            return this.code;
        }

        private SignatureMode(int code) {
            this.code = (byte)code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CounterMode {
        NO_COUNTER(0),
        NO_CHECKING(1),
        PROCESS_IF_HIGHER(2),
        PROCESS_IF_NEXT(3);

        private byte code;

        public byte code() {
            return this.code;
        }

        private CounterMode(int code) {
            this.code = (byte)code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReplyMode {
        NO_REPLY(0),
        REQUIRED(1),
        ONLY_IF_ERROR(2);

        private byte code;

        public byte code() {
            return this.code;
        }

        private ReplyMode(int code) {
            this.code = (byte)code;
        }
    }

    static class Pair
    implements Serializable {
        private static final long serialVersionUID = -2627281906843010373L;
        private transient KeyDescr KID;
        private transient KeyDescr KIC;
        private int counter;

        public Pair(KeyDescr KID, KeyDescr KIC, int counter) {
            this.KID = KID;
            this.KIC = KIC;
            this.counter = counter;
        }

        public KeyDescr getKID() {
            return this.KID;
        }

        public KeyDescr getKIC() {
            return this.KIC;
        }

        public String toString() {
            return "(Pair KID=" + this.KID + " KIC=" + this.KIC + " counter=" + this.counter + ')';
        }
    }
}

