/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.sms;

import com.sun.tck.bvtool.tlv.Encodable;
import com.sun.tck.bvtool.tlv.EncodingException;
import com.sun.tck.bvtool.tlv.TLVBuffer;
import com.sun.tck.bvtool.tlv.TreeNode;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDLHeader
implements Encodable,
TreeNode {
    private Type type = Type.SINGLE;
    private byte refNumber;
    private byte numberOfMessages;
    private byte sequenceNumber;

    public byte getNumberOfMessages() {
        return this.numberOfMessages;
    }

    public byte getRefNumber() {
        return this.refNumber;
    }

    public byte getSequenceNumber() {
        return this.sequenceNumber;
    }

    public UDLHeader() {
    }

    public UDLHeader(byte refNumber, byte numberOfMessages, byte sequenceNumber) {
        this();
        this.type = sequenceNumber == 1 ? Type.HEADER : Type.BODY;
        this.refNumber = refNumber;
        this.numberOfMessages = numberOfMessages;
        this.sequenceNumber = sequenceNumber;
    }

    public Type type() {
        return this.type;
    }

    @Override
    public Map<String, ? extends TreeNode> childNodes() {
        return Collections.emptyMap();
    }

    @Override
    public Object value() {
        return this;
    }

    @Override
    public void encode(TLVBuffer out) {
        out.write(this.type.code);
        if (this.type != Type.SINGLE) {
            out.write(0);
            out.write(3);
            out.write(this.refNumber);
            out.write(this.numberOfMessages);
            out.write(this.sequenceNumber);
        }
        if (this.type != Type.BODY) {
            out.write(112);
            out.write(0);
        }
    }

    private static void check(long expected, long returned) throws EncodingException {
    }

    public void decode(TLVBuffer out) throws EncodingException {
        this.type = Type.find(out.read());
        if (this.type == Type.SINGLE) {
            UDLHeader.check(28672L, out.read(2));
            return;
        }
        UDLHeader.check(3L, out.read(2));
        this.refNumber = (byte)out.read();
        this.numberOfMessages = (byte)out.read();
        this.sequenceNumber = (byte)out.read();
        if (this.type == Type.HEADER) {
            UDLHeader.check(28672L, out.read(2));
        }
    }

    public String toString() {
        return this.type == Type.SINGLE ? "(command-packet)" : "(concatenated-short-message referenceNumber=" + this.refNumber + " sequenceNumber=" + this.sequenceNumber + " numberOfMessages=" + this.numberOfMessages + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SINGLE(2, 3),
        HEADER(7, 8),
        BODY(5, 6);

        public final byte code;
        public final int length;

        private Type(int code, int length) {
            this.code = (byte)code;
            this.length = length;
        }

        static Type find(int type) throws EncodingException {
            for (Type current : Type.values()) {
                if (current.code != type) continue;
                return current;
            }
            throw new EncodingException("Unknown type: 0x" + Integer.toHexString(type));
        }
    }
}

