/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.sms;

import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.tck.bvtool.securedpacket.CompactApduPacket;
import com.sun.tck.bvtool.sms.Phone;
import com.sun.tck.bvtool.sms.SMSParser;
import com.sun.tck.bvtool.sms.UDLHeader;
import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.bvtool.tlv.ConstructedTLV;
import com.sun.tck.bvtool.tlv.Encodable;
import com.sun.tck.bvtool.tlv.EncodingException;
import com.sun.tck.bvtool.tlv.RawTLV;
import com.sun.tck.bvtool.tlv.TLV;
import com.sun.tck.bvtool.tlv.TLVBuffer;
import com.sun.tck.bvtool.tlv.TLVUtils;
import com.sun.tck.bvtool.tlv.TreeNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.SimpleTimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMS_PP_TLV
extends ConstructedTLV {
    private Phone phone = new Phone(new byte[]{18, 52, 86, 120});
    private Phone serviceCenterPhone = new Phone(new byte[]{17, 51, 85, 119});
    private Encodable packet;
    private Date date;
    private UDLHeader header;
    StringBuffer tpduString = new StringBuffer("    TPDU={\n");
    private static int refCount = 0;

    public TLV createDeviceIdentities() {
        return new RawTLV(-126, new byte[]{-125, -127});
    }

    private TLV createTPDU() throws EncodingException {
        TLVBuffer out = new TLVBuffer(256);
        out.write(64);
        this.tpduString.append("        header=0x40\n");
        this.serviceCenterPhone.encodeTP_OA(out);
        this.encodeTP_PID(out);
        this.encodeTP_DCS(out);
        this.encodeTP_SCTS(out, this.date);
        this.encodeTP_UD_as_LV(out);
        byte[] data = TLVUtils.toByteArray(out);
        return new RawTLV(-117, data);
    }

    private void encodeTP_PID(TLVBuffer out) {
        this.tpduString.append("        TP_PID=0x7F\n");
        out.write(127);
    }

    private void encodeTP_DCS(TLVBuffer out) {
        this.tpduString.append("        TP_DCS=0xF6\n");
        out.write(246);
    }

    private void encodeTP_SCTS(TLVBuffer out, Date current) {
        current = current == null ? new Date() : current;
        Calendar cal = Calendar.getInstance();
        cal.setTime(current);
        out.write(SMSParser.swapNibble(cal.get(1) % 100, 10));
        out.write(SMSParser.swapNibble(cal.get(2) + 1, 10));
        out.write(SMSParser.swapNibble(cal.get(5), 10));
        out.write(SMSParser.swapNibble(cal.get(11), 10));
        out.write(SMSParser.swapNibble(cal.get(12), 10));
        out.write(SMSParser.swapNibble(cal.get(13), 10));
        int timezone = cal.getTimeZone().getOffset(current.getTime()) / 900000;
        if (timezone < 0) {
            out.write(SMSParser.swapNibble(-timezone, 10) | 8);
        } else {
            out.write(SMSParser.swapNibble(timezone, 10));
        }
        this.tpduString.append("        TP_SCTS=").append(current).append("\n");
    }

    private static Date decodeTP_SCTS(TLVBuffer in) throws EncodingException {
        Calendar cal = Calendar.getInstance();
        cal.set(1, SMSParser.swapNibble(in.read(), 16, 10) + 2000);
        cal.set(2, SMSParser.swapNibble(in.read(), 16, 10) - 1);
        cal.set(5, SMSParser.swapNibble(in.read(), 16, 10));
        cal.set(11, SMSParser.swapNibble(in.read(), 16, 10));
        cal.set(12, SMSParser.swapNibble(in.read(), 16, 10));
        cal.set(13, SMSParser.swapNibble(in.read(), 16, 10));
        int tmz = in.read();
        int sign = (tmz & 8) != 0 ? -1 : 1;
        tmz = SMSParser.swapNibble(tmz & 0xF7, 16, 10) * sign;
        cal.setTimeZone(new SimpleTimeZone(tmz * 15 * 60000, "RawOffset"));
        return cal.getTime();
    }

    private void encodeUDHL(TLVBuffer out) {
        this.header.encode(out);
    }

    private void encodeTP_UD_as_LV(TLVBuffer out) throws EncodingException {
        TLVBuffer TP_UDL = out.createChild(1);
        this.encodeUDHL(out);
        this.packet.encode(out);
        TP_UDL.write(out.getPos() - TP_UDL.end());
    }

    private void init() throws EncodingException {
        this.addIfNonNull("device-identities", this.createDeviceIdentities());
        this.addIfNonNull("address", this.createAddress());
        this.addIfNonNull("tpdu", this.createTPDU());
    }

    private TLV createAddress() {
        return new RawTLV(-122, this.phone.toBytes());
    }

    public void addIfNonNull(String name, TLV tlv) {
        if (tlv != null) {
            this.add(name, tlv);
        }
    }

    private SMS_PP_TLV() throws Exception {
        this.setTag((byte)-47, null);
    }

    private SMS_PP_TLV(UDLHeader header, Encodable packet) throws EncodingException {
        this.setTag((byte)-47, null);
        this.packet = packet;
        this.header = header;
    }

    private static synchronized byte createReferenceNumber() {
        return (byte)(++refCount);
    }

    public static List<SMS_PP_TLV> create(Card card, int length, CommandAPDU ... apdus) throws EncodingException {
        CompactApduPacket packet = new CompactApduPacket(apdus);
        packet.init(card);
        return SMS_PP_TLV.create(card, length, packet);
    }

    public static List<SMS_PP_TLV> create(Card card, int length, Encodable packet) throws EncodingException {
        byte[] data = TLVUtils.encode(packet);
        if (data.length <= length) {
            SMS_PP_TLV sms = new SMS_PP_TLV(new UDLHeader(), new TreeNode.Data("compact-apdu", data));
            sms.phone = card.getPhone();
            sms.serviceCenterPhone = card.getServiceCenterPhone();
            sms.init();
            return Collections.singletonList(sms);
        }
        ArrayList<SMS_PP_TLV> retVal = new ArrayList<SMS_PP_TLV>();
        int count = data.length / length;
        count += data.length % length > 0 ? 1 : 0;
        byte refNumber = SMS_PP_TLV.createReferenceNumber();
        for (int i = 0; i < count; ++i) {
            int offset = i * length;
            int toDo = Math.min(data.length - offset, length);
            TreeNode.Data part = new TreeNode.Data("data-" + i, data, offset, toDo);
            UDLHeader header = new UDLHeader(refNumber, (byte)count, (byte)(i + 1));
            SMS_PP_TLV sms = new SMS_PP_TLV(header, part);
            sms.phone = card.getPhone();
            sms.serviceCenterPhone = card.getServiceCenterPhone();
            sms.init();
            retVal.add(sms);
        }
        return retVal;
    }

    public String getShortDescription() {
        return this.header.toString();
    }
}

