/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.sms;

import com.sun.tck.bvtool.securedpacket.ResponsePacket;
import com.sun.tck.bvtool.sms.Phone;
import com.sun.tck.bvtool.sms.UDLHeader;
import com.sun.tck.bvtool.tlv.EncodingException;
import com.sun.tck.bvtool.tlv.TLV;
import com.sun.tck.bvtool.tlv.TLVBuffer;
import com.sun.tck.bvtool.tlv.TreeNode;

public class SMSParser {
    public static Object parseValidityPeriod(int header, TLVBuffer in) throws EncodingException {
        int type = header >> 3 & 3;
        switch (type) {
            case 0: {
                return null;
            }
            case 2: {
                return Integer.toHexString(in.read() & 0xFF);
            }
            case 1: 
            case 3: {
                return Long.toHexString(in.read(7));
            }
        }
        return null;
    }

    public static void initSMS(TLV parent, byte[] data) throws EncodingException {
        TLVBuffer buff = new TLVBuffer(data);
        int header = 0xFF & data[0];
        int TP_MTI = header & 3;
        switch (TP_MTI) {
            case 0: {
                SMSParser.parse_SMS_Deliver_Report(parent, buff);
                break;
            }
            case 1: {
                SMSParser.parse_SMS_Submit(parent, buff);
                break;
            }
            case 2: {
                SMSParser.parse_SMS_Command(parent, buff);
                break;
            }
            default: {
                throw new EncodingException("Unknown type: " + TP_MTI);
            }
        }
    }

    private static void parse_SMS_Deliver_Report(TLV parent, TLVBuffer data) throws EncodingException {
        parent.add("header", new TreeNode.Data("header", data.read()));
    }

    private static void parse_SMS_Command(TLV parent, TLVBuffer data) {
    }

    private static void parse_SMS_Submit(TLV parent, TLVBuffer data) throws EncodingException {
        int header = data.read();
        parent.addByte("header", header);
        parent.addByte("TP-MR", data.read());
        parent.add("TP-DA", new TreeNode.Value("TP-DA", Phone.parseTP_DA(data)));
        parent.addByte("TP-PID", data.read());
        parent.addByte("TP-DCS", data.read());
        Object tpVp = SMSParser.parseValidityPeriod(header, data);
        if (tpVp != null) {
            parent.add("TP-VP", new TreeNode.Value("TP-VP", tpVp));
        }
        int length = data.read();
        UDLHeader udlHeader = new UDLHeader();
        udlHeader.decode(data);
        parent.add("UDL-HEADER", udlHeader);
        if (udlHeader.type() == UDLHeader.Type.SINGLE) {
            ResponsePacket pack = new ResponsePacket(true);
            pack.decode(parent.getFactory(), data);
            parent.add("response", pack);
        } else {
            byte[] respData = data.readArray(length - udlHeader.type().length);
            parent.add("response", new TreeNode.Data("response", respData));
        }
    }

    static int swapNibble(int value, int inBase) {
        return SMSParser.swapNibble(value, inBase, 16);
    }

    static int swapNibble(int value, int inBase, int outBase) {
        return (value %= inBase * inBase) % inBase * outBase + value / inBase;
    }
}

