/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.security;

import com.sun.tck.bvtool.security.Checksum;
import com.sun.tck.bvtool.security.CryptographicChecksum;
import com.sun.tck.bvtool.security.KeyType;
import com.sun.tck.me.utils.Utils;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public class KeyDescr {
    public final KeyType type;
    public final byte keyId;
    public final Cipher cipher;
    public final Cipher decipher;
    public final Checksum checksum;
    public int blockSize = 8;
    private final String password;

    public KeyDescr(KeyType type, int keyId, byte[] password) throws GeneralSecurityException {
        this.type = type;
        this.keyId = (byte)keyId;
        this.cipher = type.createCipher(1, password);
        this.decipher = type.createCipher(2, password);
        this.checksum = new CryptographicChecksum(this);
        this.password = Utils.canonize(password);
    }

    public int encodeKey() {
        return 0xFF & (this.keyId << 4 | this.type.getCode());
    }

    public String toString() {
        return "(type=" + (Object)((Object)this.type) + " id=" + this.keyId + " key=" + this.password + ")";
    }
}

