/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.securedpacket;

import com.sun.tck.bvtool.securedpacket.SecuredPacketTLV;
import com.sun.tck.bvtool.security.Checksum;
import com.sun.tck.bvtool.security.KeyDescr;
import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.bvtool.tlv.EncodingException;
import com.sun.tck.bvtool.tlv.TLVBuffer;
import com.sun.tck.bvtool.tlv.TreeNode;
import com.sun.tck.me.utils.Tracer;
import com.sun.tck.me.utils.Utils;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Cipher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HeaderTLV
implements TreeNode,
SecuredPacketTLV.Header,
SecuredPacketTLV.HeaderEncoder,
SecuredPacketTLV.HeaderDecoder {
    protected Card card;
    protected long counter;
    protected TLVBuffer buffer;
    protected TLVBuffer.Position startValue;
    protected TLVBuffer checkSumSection;
    protected TLVBuffer.Position decodedCheckSum;
    protected byte[] checkSum;
    protected byte PCNTR;
    protected byte KID;
    private boolean isInitialized = false;
    private int tar = 0;
    public ArrayList<TLVBuffer> includeToCheckSum = new ArrayList();
    public ArrayList<TLVBuffer> includeToCipher = new ArrayList();
    protected byte[] securedData;
    protected TLVBuffer.Position securedDataPos;
    protected int headerlength;
    protected TLVBuffer.Position startEncryptedData;

    protected void initData() {
    }

    void init() {
        if (this.isInitialized) {
            return;
        }
        this.includeToCheckSum.clear();
        this.includeToCipher.clear();
        this.initData();
        this.isInitialized = true;
    }

    public byte getKID() {
        return this.KID;
    }

    public byte getPCNTR() {
        return this.PCNTR;
    }

    public long getCNTR() {
        return this.counter;
    }

    @Override
    public void setTAR(int tar) {
        this.tar = tar;
    }

    @Override
    public int getTAR() {
        return this.tar;
    }

    private Checksum checksum() {
        if (this.card == null) {
            return null;
        }
        KeyDescr key = this.card == null ? null : this.card.getKID();
        return key == null ? null : key.checksum;
    }

    @Override
    public void init(Card card) {
        this.card = card;
        this.counter = card.getCounter();
    }

    private KeyDescr getCipher() {
        return this.card == null ? null : this.card.getKIC();
    }

    @Override
    public void sign() throws GeneralSecurityException {
        if (this.checkSumSection != null) {
            KeyDescr key = this.card == null ? null : this.card.getKID();
            this.checkSum = this.calculateCheckSum(key);
            this.checkSumSection.write(this.checkSum);
            Tracer.trace("createChecksum:" + Utils.canonize(this.checkSum));
        }
    }

    private byte[] calculateCheckSum(KeyDescr key) throws GeneralSecurityException {
        Checksum checksum;
        if (key == null || (checksum = key.checksum) == null) {
            return new byte[0];
        }
        int start = this.buffer.start();
        checksum.update(this.buffer.getBuffer(), start, this.checkSumSection.start() - start);
        checksum.update(this.securedData, 0, this.securedData.length);
        checksum.update(new byte[16], 0, this.PCNTR);
        Tracer.trace("SIGNING:" + Utils.canonize(this.buffer.getBuffer(), start, this.checkSumSection.start() - start) + Utils.canonize(this.securedData) + Utils.canonize(new byte[16], 0, this.PCNTR));
        return checksum.calculateCheckSum();
    }

    @Override
    public void verify() throws GeneralSecurityException, EncodingException {
        if (this.checkSumSection == null) {
            return;
        }
        KeyDescr key = this.card == null ? null : this.card.getKID(this.KID);
        byte[] calculated = this.calculateCheckSum(key);
        if (!Arrays.equals(this.checkSum, calculated)) {
            throw new EncodingException("verification fails. Expected:0x" + Utils.canonize(this.checkSum) + " Received:0x" + Utils.canonize(calculated));
        }
    }

    @Override
    public SecuredPacketTLV.HeaderDecoder decoder() {
        return this;
    }

    @Override
    public SecuredPacketTLV.HeaderEncoder encoder() {
        return this;
    }

    @Override
    public void setBuffer(TLVBuffer fullTLV, TLVBuffer.Position data) {
        this.buffer = fullTLV;
        this.startValue = data;
    }

    @Override
    public void write() throws EncodingException {
        byte length;
        this.init();
        this.buffer.setPosTo(this.startValue.pos());
        this.buffer.skip(1);
        this.writeHeaderData(this.buffer);
        Checksum checksum = this.checksum();
        if (checksum != null && checksum.getLength() != 0) {
            this.checkSumSection = this.buffer.createChild(checksum.getLength());
        }
        this.buffer.getBuffer()[this.startValue.pos()] = length = (byte)(this.buffer.getPos() - this.startValue.pos() - 1);
        this.securedDataPos = this.buffer.createPosition();
        this.buffer.write(this.securedData);
        this.buffer.write(0L, this.PCNTR);
    }

    @Override
    public void setData(byte[] securedData) {
        int blockSize;
        int rem;
        this.securedData = securedData;
        KeyDescr cipher = this.getCipher();
        this.PCNTR = cipher != null ? (byte)((rem = (securedData.length + 6) % (blockSize = this.getCipher().blockSize)) == 0 ? 0 : blockSize - rem) : (byte)0;
    }

    @Override
    public void encrypt() throws GeneralSecurityException {
        KeyDescr cipher = this.getCipher();
        if (cipher == null) {
            return;
        }
        this.process(cipher.cipher, this.buffer.getPos());
    }

    @Override
    public void decrypt() throws GeneralSecurityException {
        KeyDescr cipher = this.getCipher();
        if (cipher == null) {
            return;
        }
        this.process(cipher.decipher, this.buffer.end());
    }

    private void process(Cipher cipher, int end) throws GeneralSecurityException {
        byte[] buff = this.buffer.getBuffer();
        int offset = this.startEncryptedData.pos();
        int length = end - offset;
        Tracer.trace("Processing:" + Utils.canonize(buff, offset, length));
        Tracer.trace("process offset=" + offset + " length=" + length);
        byte[] tmp = new byte[length];
        cipher.doFinal(buff, offset, length, tmp, 0);
        System.arraycopy(tmp, 0, buff, offset, length);
    }

    public abstract void writeHeaderData(TLVBuffer var1) throws EncodingException;

    @Override
    public Map<String, ? extends TreeNode> childNodes() {
        return Collections.emptyMap();
    }

    @Override
    public Object value() {
        return this;
    }
}

