/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.securedpacket;

import com.sun.javacard.cjck.userinterface.CommandAPDU;

public class APDUUtils {
    public static final byte GET_RESPONSE_CLA = 0;
    public static final byte GET_RESPONSE_INS = -64;

    public static CommandAPDU removeLeIfCase4(CommandAPDU apdu) {
        if (apdu.getLe() == 0 || apdu.getLc() == 0) {
            return apdu;
        }
        byte[] data = apdu.getBytes();
        byte[] modified = new byte[data.length - 1];
        System.arraycopy(data, 0, modified, 0, modified.length);
        return new CommandAPDU(modified);
    }

    public static CommandAPDU createResponseApdu(int le) {
        return new CommandAPDU(new byte[]{0, -64, 0, 0, (byte)le});
    }

    public static CommandAPDU setLe(CommandAPDU apdu, byte le) {
        return APDUUtils.setLeAndP2(apdu, apdu.getP2(), le);
    }

    public static CommandAPDU setLeAndP2(CommandAPDU apdu, byte p2, byte le) {
        byte[] updatedData;
        if (apdu.getP2() == p2 && (apdu.getLe() & 0xFF) == (le & 0xFF)) {
            return apdu;
        }
        byte[] data = apdu.data;
        switch (apdu.getCase()) {
            case CASE_3S: {
                updatedData = new byte[data.length + 1];
                break;
            }
            case CASE_4S: {
                updatedData = new byte[data.length];
                break;
            }
            default: {
                throw new IllegalArgumentException("Can not change le for " + apdu);
            }
        }
        System.arraycopy(data, 0, updatedData, 0, data.length);
        updatedData[updatedData.length - 1] = le;
        updatedData[3] = p2;
        return new CommandAPDU(updatedData);
    }
}

