/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.gp;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.tck.bvtool.gp.GPCapFileInfo;
import com.sun.tck.bvtool.gp.GPOverETSICardService;
import com.sun.tck.bvtool.gp.GSMCardConfigurator;
import com.sun.tck.bvtool.securedpacket.APDUUtils;
import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.bvtool.tlv.AID_TLV;
import com.sun.tck.bvtool.tlv.ConstantBundle;
import com.sun.tck.bvtool.tlv.RawTLV;
import com.sun.tck.bvtool.tlv.TLV;
import com.sun.tck.bvtool.tlv.TLVBuffer;
import com.sun.tck.bvtool.tlv.TLVPrototypeFactory;
import com.sun.tck.bvtool.tlv.TLVUtils;
import com.sun.tck.me.utils.CommandLine;
import com.sun.tck.me.utils.CommandLineAdapter;
import com.sun.tck.me.utils.User;
import com.sun.tck.me.utils.Utils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolMain {
    private GPOverETSICardService service;

    public ToolMain(GPOverETSICardService service) {
        this.service = service;
    }

    public ResponseAPDU send(CommandAPDU apdu) throws CardProxyException {
        return this.service.sendAPDU(apdu);
    }

    public ResponseAPDU send_sms(CommandAPDU apdu) throws CardProxyException {
        return this.service.sendApduToCardManager(apdu);
    }

    public boolean install(String[] args) throws Exception {
        String capFile = args[0];
        AppletProperties[] applets = new AppletProperties[args.length - 1];
        for (int i = 0; i < applets.length; ++i) {
            applets[i] = this.parse(args[i + 1].split(","), 0);
        }
        boolean retVal = this.service.installCAPFile(applets, capFile, ".");
        StringBuilder line = new StringBuilder("install(capFile=").append(capFile);
        for (AppletProperties applet : applets) {
            line.append(" ").append(applet.getAID());
        }
        line.append(")");
        this.out(line + (retVal ? " is SUCCESSFUL" : " is FAILED"));
        return retVal;
    }

    public void installApplet(String[] args) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException(I18n.getString("aid.not.defined"));
        }
        String val = args[0];
        AppletID parent = this.parsePackageAidFromFileOrHex(val);
        AppletProperties applet = this.parse(args, 1);
        boolean status = this.service.installForInstall(val, parent, applet, this.service.includeMakeSelectable);
        this.out("INSTALL(for INSTALL) " + (status ? "PASSED" : "FAILED"));
        if (status && !this.service.includeMakeSelectable) {
            status = this.service.installForMakeSelectable(val, applet);
            this.out("INSTALL(for MAKE SELECTABLE) " + (status ? "PASSED" : "FAILED"));
        }
    }

    private AppletProperties parse(String[] list, int offset) {
        AppletProperties retVal = new AppletProperties("unknown.package", null, "unknown.class");
        retVal.setAID(new AppletID(Utils.parse(list[offset++])));
        if (offset >= list.length) {
            return retVal;
        }
        if (list[offset].startsWith("app:")) {
            retVal.setParms(Utils.parse(list[offset].substring(4)));
        } else if (!list[offset].isEmpty()) {
            retVal.setGPParameters(Utils.parse(list[offset]));
        }
        if (list.length > ++offset && list[offset].length() > 0) {
            retVal.setPrivileges(Integer.parseInt(list[offset++], 16));
        }
        return retVal;
    }

    private AppletID parsePackageAidFromFileOrHex(String val) throws IOException {
        return Utils.isHexString(val) ? new AppletID(Utils.parse(val)) : GPCapFileInfo.createData((PrintWriter)this.service.out, (String)val).packageAID;
    }

    public void delete_Package(String[] args) throws IOException, CardProxyException {
        AppletID aid = this.parsePackageAidFromFileOrHex(args[0]);
        boolean status = this.service.deletePackage(aid, "no-name");
        this.out("deletePackage(" + aid + ") returns " + status);
    }

    public void delete_Applet(String[] args) throws IOException, CardProxyException {
        AppletProperties applet = new AppletProperties("no-name", null, "no-name");
        AppletID aid = new AppletID(Utils.parse(args[0]));
        applet.setAID(aid);
        boolean status = this.service.deleteAppletInstances(new AppletProperties[]{applet});
        this.out("deleteApplet(" + aid + ") returns " + status);
    }

    public void delete(String[] args) throws IOException, CardProxyException {
        AppletID aid = this.parsePackageAidFromFileOrHex(args[0]);
        boolean status = this.service.deletePackageAndInstances(aid, "no-name");
        this.out("deletePackageAndInstances(" + aid + ") returns " + status);
    }

    public void list(String[] args) throws Exception {
        byte p1;
        String type;
        String string = type = args.length == 0 ? "executable" : args[0];
        if (type.equalsIgnoreCase("executable")) {
            p1 = 16;
        } else if (type.equalsIgnoreCase("executableFiles")) {
            p1 = 32;
        } else if (type.equalsIgnoreCase("applications")) {
            p1 = 64;
        } else if (type.equalsIgnoreCase("issuer")) {
            p1 = -128;
        } else {
            this.service.out("ERROR: Unknown type:" + type + " Allowed types are " + "executable, executableFiles, applications, issuer");
            return;
        }
        byte[] criteria = args.length > 1 ? Utils.parse(args[1]) : new byte[]{};
        RawTLV criteriaTlv = new RawTLV(79, criteria);
        CommandAPDU apdu = new CommandAPDU(-128, -14, p1, 2, criteriaTlv.toByteArray(), -1);
        ArrayList<ResponseAPDU> data = this.getStatus(apdu, new ArrayList<Integer>());
        this.out("------------------------LIST RESULTS------------------------");
        for (TLV tlv : this.parseStatus(data)) {
            this.out(tlv.toString());
        }
        this.out("------------------------LIST RESULTS------------------------");
    }

    public ResponseAPDU select(String aid) throws CardProxyException {
        byte[] bytes = Utils.parse(aid);
        return this.service.sendAPDU(new CommandAPDU(0, -92, 4, 0, bytes, 127));
    }

    private ResponseAPDU startGetDataSession(CommandAPDU apdu, ArrayList<Integer> lengths) throws Exception {
        ResponseAPDU answer;
        int sw;
        if (lengths.size() > 0) {
            apdu = APDUUtils.setLe(apdu, (byte)lengths.get(0).intValue());
        }
        if (((sw = (answer = this.send_sms(apdu)).sw()) & 0xFF00) == 27648) {
            this.checkConsistency(lengths, 0);
            lengths.add(new Integer(0xFF & sw));
            return this.startGetDataSession(apdu, lengths);
        }
        return answer;
    }

    private void checkConsistency(ArrayList<Integer> lengths, int index) {
        if (lengths.size() > index) {
            throw new IllegalArgumentException("Can not get data. New session is inconsistent");
        }
    }

    private void out(String msg) {
        this.service.out(msg);
    }

    private ArrayList<ResponseAPDU> getStatus(CommandAPDU apdu, ArrayList<Integer> lengths) throws Exception {
        ArrayList<ResponseAPDU> retVal = new ArrayList<ResponseAPDU>();
        ResponseAPDU answer = this.startGetDataSession(apdu, lengths);
        retVal.add(answer);
        CommandAPDU current = apdu;
        int pos = 1;
        while (answer.sw() == 25360) {
            int le = pos < lengths.size() ? lengths.get(pos) : 255;
            current = APDUUtils.setLeAndP2(apdu, (byte)(apdu.getP2() | 1), (byte)le);
            answer = this.send_sms(current);
            int sw = answer.sw();
            if ((sw & 0xFF00) == 27648) {
                this.checkConsistency(lengths, pos);
                lengths.add(new Integer(0xFF & sw));
                this.service.reset();
                return this.getStatus(apdu, lengths);
            }
            retVal.add(answer);
            ++pos;
        }
        return retVal;
    }

    private ArrayList<TLV> parseStatus(ArrayList<ResponseAPDU> apdus) throws Exception {
        ArrayList<TLV> retVal = new ArrayList<TLV>();
        TLVPrototypeFactory factory = new TLVPrototypeFactory(true);
        factory.registerClass((byte)79, AID_TLV.class);
        factory.registerClass((byte)-124, AID_TLV.class);
        ConstantBundle bundle = new ConstantBundle();
        bundle.register(227, "GlobalPlatform Registry Data");
        bundle.register(79, "AID");
        bundle.register(40816, "Life Cycle State");
        bundle.register(197, "Application Privileges");
        bundle.register(132, "Executable Module AID");
        factory.setTagNames(bundle);
        for (ResponseAPDU rApdu : apdus) {
            TLVBuffer data = new TLVBuffer(rApdu.getResponseData());
            try {
                while (data.available() > 0) {
                    TLV tlv = TLVUtils.parse(factory, data);
                    this.out(tlv.toString());
                    retVal.add(tlv);
                }
            }
            catch (Exception e) {
                this.out("Can not parse APDU data:0x" + Utils.canonize(rApdu.getResponseData()));
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] list) throws Exception {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(System.out));
        GPOverETSICardService service = new GPOverETSICardService();
        GSMCardConfigurator configurator = new GSMCardConfigurator();
        try {
            ToolMain tool = new ToolMain(service);
            CommandLine cmd = new CommandLine(tool, service);
            CommandLineAdapter adapter = new CommandLineAdapter(service, cmd, configurator);
            adapter.init(list);
            configurator.init();
            try {
                configurator.validate();
            }
            catch (IllegalArgumentException e) {
                System.out.println("ERROR: " + e.getMessage());
                Object var9_8 = null;
                out.flush();
                Card card = configurator.getCard();
                if (card != null) {
                    card.flush();
                }
                service.stop();
                return;
            }
            service.setCard(configurator.getCard());
            service.init(new String[]{"-doNotCleanCards"}, out, out);
            service.startTest(".", 10);
            out.flush();
            service.setUser(cmd.isBatch() ? User.NOT_INTERACTIVE : User.INTERACTIVE);
            cmd.run();
            Object var9_9 = null;
            out.flush();
            Card card = configurator.getCard();
            if (card != null) {
                card.flush();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            out.flush();
            Card card = configurator.getCard();
            if (card != null) {
                card.flush();
            }
            service.stop();
            throw throwable;
        }
        service.stop();
    }
}

