/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.gp;

import java.util.ArrayList;

public class GPConstants {
    private static GPConstants defaultName;
    private static GPConstants load;
    private static GPConstants install;
    private static GPConstants tck;
    private static GPConstants delete;
    private ArrayList<Descr> list = new ArrayList();
    private GPConstants[] parents;

    private GPConstants(GPConstants ... parents) {
        this.parents = parents;
    }

    public String findName(int sw) {
        sw &= 0xFFFF;
        for (Descr descr : this.list) {
            if ((descr.mask & sw) != descr.sw) continue;
            return descr.name + "(0x" + Integer.toHexString(sw) + ")";
        }
        for (GPConstants gp : this.parents) {
            String name = gp.findName(sw);
            if (name == null) continue;
            return name;
        }
        return "Unknown(0x" + Integer.toHexString(sw) + ")";
    }

    private void add(int sw, String name, int mask) {
        this.list.add(new Descr(name, sw, mask));
    }

    private void add(int sw, String name) {
        this.add(sw, name, 65535);
    }

    public static synchronized GPConstants getDefault() {
        if (defaultName != null) {
            return defaultName;
        }
        defaultName = new GPConstants(new GPConstants[0]);
        defaultName.add(36864, "ISO-7816-4 - SW OK");
        defaultName.add(25600, "GP 2.1.1 - No Specific Diagnosis");
        defaultName.add(26368, "GP 2.1.1 - Wrong length in Lc");
        defaultName.add(26753, "GP 2.1.1 - Logical channel not supported or is not active");
        defaultName.add(27010, "GP 2.1.1 - Security status not satisfied");
        defaultName.add(27013, "GP 2.1.1 - Conditions of use not satisfied");
        defaultName.add(27270, "GP 2.1.1 - Incorrect P1 P2");
        defaultName.add(27904, "GP 2.1.1 - Checking error: Invalid instruction");
        defaultName.add(28160, "GP 2.1.1 - Checking error: Invalid class");
        defaultName.add(24832, "ISO-7816-4 - Normal Processing: SW2 encodes the number of data bytes still available", 65280);
        defaultName.add(25088, "ISO-7816-4 - Warning processing: State of non-volatile memory is unchanged.", 65280);
        defaultName.add(25344, "ISO-7816-4 - Warning processing: State of non-volatile memory has changed.", 65280);
        defaultName.add(25600, "ISO-7816-4 - Execution error: State of non-volatile memory is unchanged", 65280);
        defaultName.add(25856, "ISO-7816-4 - Execution error: State of non-volatile memory has changed", 65280);
        defaultName.add(26112, "ISO-7816-4 - Execution error: Security-related issues", 65280);
        defaultName.add(26368, "ISO-7816-4 - Checking error: Wrong length; no further indication");
        defaultName.add(26624, "ISO-7816-4 - Checking error: Functions in CLA not supported", 65280);
        defaultName.add(26880, "ISO-7816-4 - Checking error: Command not allowed", 65280);
        defaultName.add(27136, "ISO-7816-4 - Checking error: Wrong parameters P1-P2", 65280);
        defaultName.add(27392, "ISO-7816-4 - Checking error: Wrong parameters P1-P2");
        defaultName.add(27648, "ISO-7816-4 - Checking error: Wrong Le field; SW2 encodes the exact number of available data bytes", 65280);
        defaultName.add(28416, "ISO-7816-4 - Checking error: No precise diagnosis");
        return defaultName;
    }

    public static synchronized GPConstants getInstall() {
        if (install != null) {
            return install;
        }
        install = new GPConstants(GPConstants.getDefault());
        install.add(25985, "GP 2.1.1 - Memory failure");
        install.add(27272, "GP 2.1.1 - Referenced data not found");
        install.add(27264, "GP 2.1.1 - Incorrect parameters in data field");
        install.add(27268, "GP 2.1.1 - Not enough memory space");
        return install;
    }

    public static synchronized GPConstants getLoad() {
        if (load != null) {
            return load;
        }
        load = new GPConstants(GPConstants.getDefault());
        load.add(25985, "GP 2.1.1 - Memory failure");
        load.add(27268, "GP 2.1.1 - Not enough memory space");
        return load;
    }

    public static synchronized GPConstants getDelete() {
        if (delete != null) {
            return delete;
        }
        delete = new GPConstants(GPConstants.getDefault());
        delete.add(25985, "GP 2.1.1 - Memory failure");
        delete.add(27272, "GP 2.1.1 - Referenced data not found");
        delete.add(27266, "GP 2.1.1 - Application not found");
        delete.add(27264, "GP 2.1.1 - Incorrect values in command data");
        return delete;
    }

    public static synchronized GPConstants getTck() {
        if (tck != null) {
            return tck;
        }
        tck = new GPConstants(GPConstants.getInstall(), GPConstants.getDelete());
        tck.add(39680, "TCK - TestPassed");
        tck.add(39680, "TCK - TestFailed", 65280);
        tck.add(39936, "TCK - TestUnexpectedError", 65280);
        return tck;
    }

    private static class Descr {
        int sw;
        int mask = 65535;
        String name;

        Descr(String name, int sw, int mask) {
            this.name = name;
            this.sw = sw;
            this.mask = mask;
        }
    }
}

