/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.util.StringArray;
import com.sun.jck.lib.I18n;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public class MessageSwitch {
    private static final int DEFAULT_BACKLOG = 5;
    private Thread listener;
    private ServerSocket serverSocket;
    private boolean stopping;
    private Vector taskList = new Vector();

    public MessageSwitch() throws IOException {
        this(5);
    }

    public MessageSwitch(int backlog) throws IOException {
        this.serverSocket = new ServerSocket(0, backlog);
        this.listener = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    MessageSwitch.this.listen();
                }
                catch (IOException iOException) {
                    MessageSwitch messageSwitch = MessageSwitch.this;
                    synchronized (messageSwitch) {
                        MessageSwitch.this.listener = null;
                    }
                }
                finally {
                    MessageSwitch messageSwitch = MessageSwitch.this;
                    synchronized (messageSwitch) {
                        MessageSwitch.this.listener = null;
                    }
                }
            }
        };
        this.listener.setName("MessageSwitch.listener");
        this.listener.start();
    }

    public String getHostAndPort() throws UnknownHostException {
        InetAddress here = InetAddress.getLocalHost();
        return here.getHostName() + ":" + String.valueOf(this.serverSocket.getLocalPort());
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    private synchronized void broadcast(Task from, String[] args) {
        for (int i = 0; i < this.taskList.size(); ++i) {
            Task t = (Task)this.taskList.elementAt(i);
            if (t == from) continue;
            t.send(from, args);
        }
    }

    private synchronized void send(Task from, String taskName, String[] args) {
        for (int i = 0; i < this.taskList.size(); ++i) {
            Task t = (Task)this.taskList.elementAt(i);
            if (!taskName.equals(t.name)) continue;
            t.send(from, args);
            return;
        }
        throw new IllegalArgumentException(taskName);
    }

    public synchronized void close() {
        this.stopping = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        if (this.listener != null) {
            this.listener.interrupt();
        }
        for (int i = 0; i < this.taskList.size(); ++i) {
            Task t = (Task)this.taskList.elementAt(i);
            t.stop();
        }
    }

    protected void handleException(Exception e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen() throws IOException {
        while (!this.stopping) {
            Socket s = this.serverSocket.accept();
            Task t = new Task(s);
            new Thread(t).start();
            MessageSwitch messageSwitch = this;
            synchronized (messageSwitch) {
                this.taskList.addElement(t);
                this.notifyAll();
            }
        }
    }

    private class Task
    implements Runnable {
        String name;
        Socket socket;
        DataInputStream in;
        DataOutputStream out;

        Task(Socket s) throws IOException {
            this.socket = s;
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            System.err.println(I18n.getString("msgswitch.open.to", s.getInetAddress()));
        }

        public synchronized void send(Task from, String[] args) {
            String src = from == null || from.name == null ? "" : from.name;
            try {
                this.out.writeByte(100);
                this.out.writeUTF(src);
                this.out.writeShort(args.length);
                for (int i = 0; i < args.length; ++i) {
                    this.out.writeUTF(args[i]);
                }
                this.out.flush();
            }
            catch (IOException e) {
                MessageSwitch.this.handleException(e);
            }
        }

        public void stop() {
            this.closeAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!MessageSwitch.this.stopping) {
                    byte code = this.in.readByte();
                    System.err.println(I18n.getString("msgswitch.received", String.valueOf(code)));
                    switch (code) {
                        case 1: {
                            MessageSwitch messageSwitch = MessageSwitch.this;
                            synchronized (messageSwitch) {
                                this.name = this.in.readUTF();
                                System.err.println(I18n.getString("msgswitch.got.name", this.name));
                                MessageSwitch.this.notifyAll();
                                break;
                            }
                        }
                        case 2: {
                            String[] bArgs = new String[this.in.readShort()];
                            for (int i = 0; i < bArgs.length; ++i) {
                                bArgs[i] = this.in.readUTF();
                            }
                            System.err.println(I18n.getString("msgswitch.got.broadcast", StringArray.join((String[])bArgs)));
                            MessageSwitch.this.broadcast(this, bArgs);
                            break;
                        }
                        case 3: {
                            String sTaskName = this.in.readUTF();
                            String[] sArgs = new String[this.in.readShort()];
                            for (int i = 0; i < sArgs.length; ++i) {
                                sArgs[i] = this.in.readUTF();
                            }
                            System.err.println(I18n.getString("msgswitch.got.send", sTaskName, StringArray.join((String[])sArgs)));
                            MessageSwitch.this.send(this, sTaskName, sArgs);
                        }
                    }
                }
            }
            catch (IOException e) {
                MessageSwitch.this.handleException(e);
            }
            finally {
                if (this.name != null) {
                    MessageSwitch.this.taskList.removeElement(this.name);
                }
                this.closeAll();
            }
        }

        private void closeAll() {
            try {
                this.in.close();
            }
            catch (IOException e) {
                MessageSwitch.this.handleException(e);
            }
            try {
                this.out.close();
            }
            catch (IOException e) {
                MessageSwitch.this.handleException(e);
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                MessageSwitch.this.handleException(e);
            }
        }
    }
}

