/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.referenceimpl;

import com.sun.javacard.cjck.userinterface.BiometricDataProvider;
import com.sun.javacard.cjck.userinterface.NoSuchBioTypeException;

public class CJCREBiometricDataProvider
implements BiometricDataProvider {
    private static final byte[] SunRID = new byte[]{-96, 0, 0, 0, 98};
    private static final byte[] REFERENCE_PASSWORD = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
    private static final byte[] POSITIVE_PASSWORD = REFERENCE_PASSWORD;
    private static final byte[] NEGATIVE_PASSWORD = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
    private static final byte[] WRONG_PASSWORD = new byte[]{0, 0};

    public byte[][] getAllBiometricProvidersRIDs() {
        return new byte[][]{SunRID};
    }

    public byte[] getDefaultBiometricProviderRID() {
        return SunRID;
    }

    public boolean isSupportedBioType(byte bioType, byte[] RID) {
        return (RID == null || this.isSunRID(RID)) && bioType == 31;
    }

    public byte[] getAllInitParamValues(byte bioType, byte[] RID) throws NoSuchBioTypeException {
        if (RID == null || this.isSunRID(RID)) {
            switch (bioType) {
                case 31: {
                    return new byte[0];
                }
            }
            throw new NoSuchBioTypeException("Unsopported bio type :" + bioType);
        }
        return null;
    }

    public byte[] getSupportedBioTypes(byte[] RID) {
        if (RID == null || this.isSunRID(RID)) {
            return new byte[]{31};
        }
        return null;
    }

    public byte[] getReferenceBioTemplate(byte bioType, byte[] RID, byte initParam) throws NoSuchBioTypeException {
        if (RID == null || this.isSunRID(RID)) {
            switch (bioType) {
                case 31: {
                    return REFERENCE_PASSWORD;
                }
            }
            throw new NoSuchBioTypeException("Unsopported bio type :" + bioType);
        }
        return null;
    }

    public byte[] getPositiveCandidate(byte bioType, byte[] RID, byte initParam) throws NoSuchBioTypeException {
        if (RID == null || this.isSunRID(RID)) {
            switch (bioType) {
                case 31: {
                    return POSITIVE_PASSWORD;
                }
            }
            throw new NoSuchBioTypeException("Unsopported bio type :" + bioType);
        }
        return null;
    }

    public byte[] getNegativeCandidate(byte bioType, byte[] RID, byte initParam) throws NoSuchBioTypeException {
        if (RID == null || this.isSunRID(RID)) {
            switch (bioType) {
                case 31: {
                    return NEGATIVE_PASSWORD;
                }
            }
            throw new NoSuchBioTypeException("Unsopported bio type :" + bioType);
        }
        return null;
    }

    public byte[] getInvalidReferenceData(byte bioType, byte[] RID, byte initParam) throws NoSuchBioTypeException {
        if (RID == null || this.isSunRID(RID)) {
            switch (bioType) {
                case 31: {
                    return WRONG_PASSWORD;
                }
            }
            throw new NoSuchBioTypeException("Unsopported bio type :" + bioType);
        }
        return null;
    }

    public byte[] getInvalidCandidateData(byte bioType, byte[] RID, byte initParam) throws NoSuchBioTypeException {
        if (RID == null || this.isSunRID(RID)) {
            switch (bioType) {
                case 31: {
                    return new byte[0];
                }
            }
            throw new NoSuchBioTypeException("Unsopported bio type :" + bioType);
        }
        return null;
    }

    private boolean isSunRID(byte[] RID) {
        if (RID.length != SunRID.length) {
            return false;
        }
        for (int i = 0; i < RID.length; ++i) {
            if (RID[i] == SunRID[i]) continue;
            return false;
        }
        return true;
    }
}

