/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.userinterface;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.AppletID;
import java.util.Hashtable;

public class AppletProperties {
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 2;
    public static final int MIN_AID_LENGTH = 5;
    public static final int MAX_AID_LENGTH = 16;
    public static final int MAX_PARMS_LENGTH = 32;
    public static final int MAX_CODE_BYTES = 5120;
    public static final int MAX_DATA_BYTES = 2048;
    public static final int MAX_STACK_BYTES = 128;
    public static final int MAX_RAM_BYTES = 128;
    public static final byte SECURITY_DOMAIN_PRIVILEDGE = -128;
    public static final byte DAP_VERIFICATION_PRIVILEDGE = -64;
    public static final byte DELEGATED_MANAGEMENT_PRIVILEDGE = -96;
    public static final byte CARD_LOCK_PRIVILEDGE = 16;
    public static final byte CARD_TERMINATE_PRIVILEDGE = 8;
    public static final byte DEFAULT_SELECTED_PRIVILEDGE = 4;
    public static final byte CVM_MANAGEMENT_PRIVILEDGE = 2;
    public static final byte MANDATED_DAP_VERIFICATION_PRIVILEDGE = -63;
    String packageName;
    AppletID packageAID;
    String className;
    AppletID AID;
    byte[] parmArray;
    int codeBytes;
    int dataBytes;
    int maxStack;
    int maxRam;
    Hashtable ht;
    private byte priviledges;
    private int volatileSpace;
    private int nonVolatileSpace;
    private byte[] gpParameters;

    public AppletProperties(String packageName, AppletID packageAID, String className) throws IllegalArgumentException {
        if (packageAID != null && (packageAID.getBytes().length > 16 || packageAID.getBytes().length < 5)) {
            throw new IllegalArgumentException(I18n.getString("aid.out.range"));
        }
        this.packageName = packageName;
        this.className = className;
        this.packageAID = packageAID;
        this.AID = null;
        this.parmArray = null;
        this.codeBytes = -1;
        this.dataBytes = -1;
        this.maxStack = -1;
        this.maxRam = -1;
        this.ht = new Hashtable();
    }

    public void setAID(AppletID AID) throws IllegalArgumentException {
        if (AID.getBytes().length > 16 || AID.getBytes().length < 5) {
            throw new IllegalArgumentException(I18n.getString("aid.out.range"));
        }
        this.AID = AID;
    }

    public void setPackageAID(AppletID packAID) throws IllegalArgumentException {
        if (packAID.getBytes().length > 16 || packAID.getBytes().length < 5) {
            throw new IllegalArgumentException(I18n.getString("aid.out.range"));
        }
        this.packageAID = packAID;
    }

    public void setParms(byte[] parms) throws IllegalArgumentException {
        if (parms.length > 32) {
            throw new IllegalArgumentException(I18n.getString("parameter.too.long"));
        }
        if (parms.length > 0) {
            this.parmArray = new byte[parms.length];
            System.arraycopy(parms, 0, this.parmArray, 0, parms.length);
        } else {
            this.parmArray = null;
        }
    }

    public void setCodeBytes(int n) throws IllegalArgumentException {
        if (n < 0 || n > 5120) {
            throw new IllegalArgumentException(I18n.getString("codebyte.out.range"));
        }
        this.codeBytes = n;
    }

    public void setDataBytes(int n) throws IllegalArgumentException {
        if (n < 0 || n > 2048) {
            throw new IllegalArgumentException(I18n.getString("databyte.out.range"));
        }
        this.dataBytes = n;
    }

    public void setMaxStack(int n) throws IllegalArgumentException {
        if (n < 0 || n > 128) {
            throw new IllegalArgumentException(I18n.getString("stackvalue.out.range"));
        }
        this.maxStack = n;
    }

    public void setMaxRam(int n) throws IllegalArgumentException {
        if (n < 0 || n > 128) {
            throw new IllegalArgumentException(I18n.getString("rambyte.out.range"));
        }
        this.maxRam = n;
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.ht.put(propertyName, propertyValue);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public AppletID getPackageAID() {
        return this.packageAID;
    }

    public String getClassName() {
        return this.className;
    }

    public AppletID getAID() {
        return this.AID;
    }

    public byte[] getParms() {
        return this.parmArray;
    }

    public String getParmString() {
        return new String(this.parmArray);
    }

    public int getCodeBytes() {
        return this.codeBytes;
    }

    public int getDataBytes() {
        return this.dataBytes;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxRam() {
        return this.maxRam;
    }

    public String getProperty(String propertyName) {
        return (String)this.ht.get(propertyName);
    }

    private static String toHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("'class name'\t'AID'");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.className + "\t");
        byte[] aidBa = this.AID.getBytes();
        for (int i = 0; i < aidBa.length; ++i) {
            int n = aidBa[i] & 0xFF;
            if (i != 0) {
                sb.append(":");
            }
            sb.append("0x");
            sb.append(Integer.toHexString(n));
        }
        return sb.toString();
    }

    public byte getPriviledges() {
        return this.priviledges;
    }

    public void setPrivileges(int priviledges) {
        this.priviledges = (byte)priviledges;
    }

    public int getNonVolatileSpace() {
        return this.nonVolatileSpace;
    }

    public void setNonVolatileSpace(int nonVolatileSpace) {
        this.nonVolatileSpace = nonVolatileSpace;
    }

    public int getVolatileSpace() {
        return this.volatileSpace;
    }

    public void setVolatileSpace(int volatileSpace) {
        this.volatileSpace = volatileSpace;
    }

    public byte[] getGPParameters() {
        return this.gpParameters;
    }

    public void setGPParameters(byte[] systemParameters) {
        this.gpParameters = systemParameters;
    }
}

