/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.JavaCardScript;
import java.util.Vector;

public class ScriptDefinition {
    private String name;
    private String[] params;
    private Vector buff;
    private boolean isScriptFile;

    public ScriptDefinition(String name) {
        this.name = name;
        this.buff = new Vector();
    }

    public ScriptDefinition(String name, boolean isScriptFile) {
        this.name = name;
        this.buff = new Vector();
        this.isScriptFile = isScriptFile;
    }

    public ScriptDefinition(String name, String[] params) {
        this.name = name;
        this.params = params;
    }

    public boolean isScriptFile() {
        return this.isScriptFile;
    }

    public void addArgument(String arg) {
        if (this.params != null) {
            throw new IllegalArgumentException(I18n.getString("can.not.add.final.def"));
        }
        this.buff.addElement(arg);
    }

    public void addArguments(String arg1, String arg2) {
        this.addArgument(arg1);
        this.addArgument(arg2);
    }

    public String getName() {
        return this.name;
    }

    public String[] getParams() {
        if (this.params == null) {
            this.params = this.buff.toArray(new String[this.buff.size()]);
        }
        return this.params;
    }

    public JavaCardScript loadScript() throws IllegalArgumentException {
        try {
            Class<?> cl = Class.forName(this.name);
            JavaCardScript retVal = (JavaCardScript)cl.newInstance();
            retVal.setArguments(this.getParams());
            return retVal;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(I18n.getString("can.not.obtain.javacardscript", this.name));
        }
    }
}

