/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.CardProxyArguments;
import com.sun.javacard.cjck.invoke.ConfigFileReader;
import com.sun.javacard.cjck.invoke.ConvertMode;
import com.sun.javacard.cjck.invoke.DelayedPrintWriter;
import com.sun.javacard.cjck.invoke.InstallMode;
import com.sun.javacard.cjck.invoke.RunMode;
import com.sun.javacard.cjck.invoke.WrapperCardService;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CardService;
import com.sun.javacard.cjck.userinterface.CardServiceFactory;
import com.sun.javatest.Command;
import com.sun.javatest.Status;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class CardProxyTest
extends Command {
    static String VERSION = "2.2.1";
    static Date BUILD_DATE = new Date();
    static final String CONTACTED_SUPPORT = "contacted_support";
    static final String CONTACTLESS_SUPPORT = "contactless_support";
    static final String DUAL_INTERFACE_SUPPORT = "dual_interface_support";
    DelayedPrintWriter logWriter;
    DelayedPrintWriter refWriter;
    private static int instance;
    private int myInstance;
    private CardProxyArguments args;
    String log_id;
    ConfigFileReader configFile;
    CJCKCardService cardService;
    String runMode;
    private CJCKCardService contactedCardService = null;
    private CJCKCardService contactlessCardService = null;

    public CardProxyTest() {
    }

    public CardProxyTest(CJCKCardService aCardService) {
        this.myInstance = ++instance;
        this.cardService = aCardService;
        this.log_id = I18n.getString("cardproxy.log.id", new Integer(this.myInstance));
    }

    public static void main(String[] args) {
        PrintWriter log = new PrintWriter(System.out, true);
        DelayedPrintWriter logWriter = new DelayedPrintWriter(log);
        DelayedPrintWriter refWriter = new DelayedPrintWriter(new PrintWriter(System.err));
        logWriter.println(I18n.getString("cardproxy.version.build", VERSION, BUILD_DATE));
        CardProxyTest test = new CardProxyTest();
        Status status = test.run(args, logWriter, refWriter);
        if (status.isPassed()) {
            logWriter.resetData();
            refWriter.resetData();
        } else {
            logWriter.flushData();
            refWriter.flushData();
        }
        log.println(I18n.getString("cardproxy.run.status", status));
        status.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status run(String[] arguments, PrintWriter log, PrintWriter ref) {
        this.logWriter = new DelayedPrintWriter(log);
        this.refWriter = new DelayedPrintWriter(ref);
        this.log_id = I18n.getString("cardproxy.log.id", new Integer(instance));
        this.log(I18n.getString("run.starting.msg", this.log_id, VERSION, BUILD_DATE));
        Status status = this.instantiateResources(arguments);
        if (!status.isPassed()) {
            return status;
        }
        this.log(I18n.getString("java.classpath", System.getProperty("java.class.path")));
        try {
            RunMode mode = this.createMode(this.runMode);
            if (this.contactedCardService != null && this.contactlessCardService != null && !this.runMode.equals("convert") && this.args.isDuplicatedByBothIO()) {
                status = null;
                this.ref(I18n.getString("contacted.test.started"));
                mode.init(this.logWriter, this.refWriter, this.contactedCardService);
                Status runStatus = mode.run(this.args, this.configFile);
                this.ref(I18n.getString("contacted.test.status", runStatus));
                this.ref(I18n.getString("contacted.test.finished"));
                if (!runStatus.isPassed()) {
                    status = runStatus;
                }
                this.ref(I18n.getString("contactless.test.started"));
                mode.init(this.logWriter, this.refWriter, this.contactlessCardService);
                runStatus = mode.run(this.args, this.configFile);
                this.ref(I18n.getString("contactless.test.status", runStatus));
                this.ref(I18n.getString("contactless.test.finished"));
                if (status == null) {
                    status = runStatus;
                }
            } else {
                mode.init(this.logWriter, this.refWriter, this.cardService);
                status = mode.run(this.args, this.configFile);
            }
        }
        catch (CardProxyException e) {
            status = Status.failed((String)I18n.getString("cardservice.exception", e));
        }
        catch (Throwable t) {
            t.printStackTrace(this.logWriter);
            this.logWriter.flushData();
            this.refWriter.flushData();
            Status status2 = Status.error((String)I18n.getString("unexpected.exception", t));
            return status2;
        }
        finally {
            this.finalizeTest();
        }
        if (!status.isPassed()) {
            this.logWriter.flushData();
            this.refWriter.flushData();
        } else {
            this.logWriter.resetData();
            this.refWriter.resetData();
        }
        return status;
    }

    protected RunMode createMode(String mode) throws CardProxyException {
        if (mode.equals("convert")) {
            return new ConvertMode();
        }
        if (mode.equals("install")) {
            return new InstallMode();
        }
        throw new CardProxyException(I18n.getString("unknown.mode", mode));
    }

    protected Status instantiateResources(String[] args) {
        try {
            this.args = new CardProxyArguments(args);
            this.configFile = new ConfigFileReader(this.logWriter, this.refWriter);
            Enumeration e = this.args.getLibConfigFiles();
            while (e.hasMoreElements()) {
                this.configFile.read((String)e.nextElement());
            }
            this.configFile.read(this.args.getConfigFile());
            this.runMode = this.args.getRunMode();
            this.instantiateCardServices();
            return Status.passed((String)"");
        }
        catch (CardProxyException e) {
            return Status.error((String)I18n.getString("cardservice.init.exception", e));
        }
        catch (IllegalArgumentException ex) {
            return Status.failed((String)I18n.getString("can.not.parse.arg", ex));
        }
        catch (IOException io) {
            return Status.error((String)I18n.getString("can.not.read.config", io));
        }
    }

    protected void instantiateCardServices() throws CardProxyException {
        boolean dualSupport;
        Properties argProps = this.args.getProperties();
        boolean contactedSupport = argProps.getProperty(CONTACTED_SUPPORT, "true").equals("true");
        boolean contactlessSupport = argProps.getProperty(CONTACTLESS_SUPPORT, "false").equals("true");
        boolean bl = dualSupport = contactedSupport && contactlessSupport && argProps.getProperty(DUAL_INTERFACE_SUPPORT, "false").equals("true");
        if (contactedSupport) {
            this.log(I18n.getString("contacted.init"));
            this.contactedCardService = new WrapperCardService(this.getBaseCardService(), 1);
        }
        if (contactlessSupport && (this.args.isDuplicatedByBothIO() && !this.runMode.equals("convert") || !contactedSupport)) {
            this.log(I18n.getString("contactless.init"));
            this.contactlessCardService = new WrapperCardService(this.getBaseCardService(), 2, dualSupport);
        }
        if (!contactedSupport && !contactlessSupport) {
            throw new CardProxyException(I18n.getString("io.not.supported"));
        }
        this.cardService = this.contactedCardService != null ? this.contactedCardService : this.contactlessCardService;
    }

    protected CardService getBaseCardService() throws CardProxyException {
        String name = this.args.getCardServiceClass();
        String path = this.args.getClassPath();
        this.log(I18n.getString("instantiate.cjckcardservice", this.log_id, name, path));
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            loader = this.args.getClassLoader();
        }
        CardService baseService = CardServiceFactory.getCardService(name, loader);
        this.log(I18n.getString("init.cjckcardservice", this.log_id, name));
        baseService.init(this.args.getCardServiceArgs(), this.logWriter, this.refWriter);
        baseService.startTest(this.args.getOutputDir(), this.args.getNuberOfReset());
        this.log(I18n.getString("cardservice.workdir.scriptcount", this.log_id, this.args.getOutputDir(), new Integer(this.args.getScriptFileCount())));
        return baseService;
    }

    Status finalizeTest() {
        try {
            this.log(I18n.getString("call.powerdown", this.log_id));
            if (this.cardService != null) {
                this.cardService.powerDown();
                this.cardService.stopTest();
            }
            return Status.passed((String)"");
        }
        catch (CardProxyException e) {
            return Status.failed((String)I18n.getString("powerdown.got.exception", e));
        }
    }

    void log(String msg) {
        this.logWriter.println(msg);
    }

    void ref(String msg) {
        this.log(msg);
        this.refWriter.println(msg);
    }
}

