/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.ArgumentParser;
import com.sun.javacard.cjck.invoke.ScriptDefinition;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CardProxyArguments
extends ArgumentParser {
    public static final String DEFAULT_MAJOR_VERSION = "1";
    public static final String DEFAULT_MINOR_VERSION = "0";
    public static final String DEFAULT_BUNDLE_SIZE = "0";
    static final String DEFAULT_SCRIPT_CLASS_NAME = "com.sun.javacard.cjck.scripts.DoTestScript";
    private boolean[] status;
    private Hashtable excludedScripts = new Hashtable();
    private Vector<ScriptDefinition> scripts;
    private ClassLoader loader;

    public CardProxyArguments(String[] args) {
        super(new String[]{"-v", "-Verbose", "-verbose", "-cjasm", "-bothIO", "-loadStatusIgnore", "-legacyMode"}, new String[]{"-C", "-B", "-classpath", "-M", "-Property", "-R", "-Test", "-TestCount", "-capfile", "-capfiledir", "-classdir", "-exclude", "-exportdir", "-exportmapfile", "-majorversion", "-minorversion", "-mode", "-o", "-outputrootdir", "-x", "-executeClass", "-noConversion", "-refcapfiledir", "-s", "-bundle_size", "-get_response_cla_byte", "-libcapfile", "-libdir", "-libCfg"}, new String[]{"-Property", "-capfile", "-exclude", "-noConversion", "-s", "-libcapfile", "-libCfg", "-legacyMode"});
        String path;
        Vector<String> simpleArgs = new Vector<String>();
        this.scripts = new Vector();
        ScriptDefinition script = null;
        boolean isDefault = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-scriptClass") && i < args.length - 1) {
                script = new ScriptDefinition(args[++i]);
                this.scripts.addElement(script);
                continue;
            }
            if (args[i].equals("-scriptArg") && i < args.length - 1) {
                if (script == null) {
                    throw new IllegalArgumentException(I18n.getString("bad.script.argument"));
                }
                script.addArgument(args[++i]);
                continue;
            }
            if (args[i].equals("-TestCount") && i < args.length - 1) {
                isDefault = true;
            }
            simpleArgs.addElement(args[i]);
        }
        this.parseArgs(simpleArgs.toArray(new String[simpleArgs.size()]));
        Enumeration<ScriptDefinition> e = this.scripts.elements();
        while (e.hasMoreElements()) {
            ScriptDefinition sd = e.nextElement();
            if (!sd.isScriptFile()) continue;
            sd.addArguments("-workDir", this.getTestDir());
        }
        if (isDefault && this.scripts.size() == 0) {
            String scriptName = DEFAULT_SCRIPT_CLASS_NAME;
            this.scripts.addElement(new ScriptDefinition(scriptName, new String[]{"-testCount", Integer.toString(this.getTestCaseCount()), "-executeClass", this.getExecuteClass(), "-legacyMode"}));
        }
        this.loader = (path = this.getClassPath()) == null ? this.getClass().getClassLoader() : this.createPathClassLoader(path);
    }

    protected ClassLoader createPathClassLoader(String path) {
        ArrayList<URL> retVal = new ArrayList<URL>();
        StringTokenizer e = new StringTokenizer(path, File.pathSeparator);
        while (e.hasMoreTokens()) {
            File f = new File(e.nextToken());
            try {
                if (!f.exists()) continue;
                retVal.add(f.toURL());
            }
            catch (Exception e1) {}
        }
        return new URLClassLoader(retVal.toArray(new URL[retVal.size()]), this.getClass().getClassLoader());
    }

    public String getClassPath() {
        return this.getSingleOption("-classpath", true);
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getExecuteClass() {
        return this.getSingleOption("-executeClass", false);
    }

    public String getRunMode() {
        return this.getSingleOption("-mode", false);
    }

    public String getCardServiceClass() {
        return this.getSingleOption("-C", false);
    }

    public String getBiometricDataProviderClass() {
        return this.getSingleOption("-B", true);
    }

    public String getConfigFile() {
        return this.getTestDir() + File.separator + this.getSingleOption("-M", false);
    }

    public Enumeration getLibConfigFiles() {
        Vector<String> list = new Vector<String>();
        Enumeration e = this.getOption("-libCfg");
        if (e.hasMoreElements()) {
            String dir = this.getLibraryRoot() + File.separator;
            while (e.hasMoreElements()) {
                list.addElement(dir + e.nextElement());
            }
        }
        return list.elements();
    }

    public int getTestCaseCount() {
        return this.parseInt(this.getSingleOption("-TestCount", false), "-TestCount");
    }

    public int getScriptFileCount() {
        return this.scripts.size();
    }

    public Enumeration getCapFiles() {
        Vector retVal = new Vector();
        Enumeration e = this.getOption("-libcapfile");
        while (e.hasMoreElements()) {
            retVal.addElement(e.nextElement());
        }
        e = this.getOption("-capfile");
        while (e.hasMoreElements()) {
            retVal.addElement(e.nextElement());
        }
        return retVal.elements();
    }

    public Enumeration getLibraryCapFiles() {
        return this.getOption("-libcapfile");
    }

    public Enumeration getScriptFiles() {
        return this.scripts.elements();
    }

    public Enumeration getNoConvertPackages() {
        return this.getOption("-noConversion");
    }

    public boolean doConversion(String packagename) {
        Enumeration nc = this.getNoConvertPackages();
        while (nc.hasMoreElements()) {
            if (!packagename.equals((String)nc.nextElement())) continue;
            return false;
        }
        return true;
    }

    public Properties getProperties() {
        Properties retVal = new Properties();
        Enumeration e = this.getOption("-Property");
        while (e.hasMoreElements()) {
            this.putPropertyLine(retVal, (String)e.nextElement());
        }
        return retVal;
    }

    public String getTestDir() {
        return CardProxyArguments.getDirname(this.getSingleOption("-Test", false));
    }

    public String getClassDir() {
        return this.getSingleOption("-classdir", false);
    }

    public String getExportDir() {
        return this.getSingleOption("-exportdir", true);
    }

    public String getOutputDir() {
        return this.getFirstSingleOptionFromList(new String[]{"-outputrootdir", "-o"}, false);
    }

    public String getCapFileDir() {
        String name = this.getSingleOption("-capfiledir", false);
        File test = new File(name);
        if (!test.exists() || test.isDirectory()) {
            return name;
        }
        return CardProxyArguments.getDirname(name);
    }

    public String getRefCapFileDir() {
        String name = this.getSingleOption("-refcapfiledir", true);
        if (name == null) {
            return null;
        }
        File test = new File(name);
        if (!test.exists() || test.isDirectory()) {
            return name;
        }
        return CardProxyArguments.getDirname(name);
    }

    public String getLibraryRoot() {
        return this.getSingleOption("-libdir", false);
    }

    public String getExportMapFile() {
        return this.getSingleOption("-exportmapfile", true);
    }

    public boolean intSupport() {
        return "intSupport".equals(this.getSingleOption("-x", "noIntSupport"));
    }

    public int getMajorVersion() {
        return this.parseInt(this.getSingleOption("-majorversion", DEFAULT_MAJOR_VERSION), "major_version");
    }

    public int getMinorVersion() {
        return this.parseInt(this.getSingleOption("-minorversion", "0"), "minor_version");
    }

    public boolean isVerbose() {
        return this.getFirstSingleOptionFromList(new String[]{"-v", "-Verbose", "-verbose"}, true) != null;
    }

    public String[] getCardServiceArgs() {
        Vector args = this.getOptionVector("-s");
        return args == null ? new String[]{} : args.toArray(new String[args.size()]);
    }

    public int getBundleSize() {
        return this.parseInt(this.getSingleOption("-bundle_size", "0"), "-bundle_size");
    }

    private void putPropertyLine(Properties res, String line) {
        int pos;
        if (line != null && (pos = line.indexOf(61)) > 0 && pos < line.length() - 1) {
            res.setProperty(line.substring(0, pos), line.substring(pos + 1));
        }
    }

    public String[] getExcludedTestCases() {
        Vector args = this.getOptionVector("-s");
        Vector<String> retVal = new Vector<String>();
        Enumeration e = this.getOption("-exclude");
        while (e.hasMoreElements()) {
            StringTokenizer tokens = new StringTokenizer((String)e.nextElement(), ",");
            while (tokens.hasMoreTokens()) {
                retVal.addElement(tokens.nextToken());
            }
        }
        return retVal.toArray(new String[retVal.size()]);
    }

    public byte getGET_RESPONSE_CLA_BYTE() {
        return (byte)this.parseInt(this.getSingleOption("-get_response_cla_byte", "0"), "-get_response_cla_byte");
    }

    private int parseInt(String value, String name) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(I18n.getString("invalid.integer.value", name, value, e));
        }
    }

    public int getNuberOfReset() {
        return 10;
    }

    public boolean isDuplicatedByBothIO() {
        return this.getSingleOption("-bothIO", null) != null;
    }

    public boolean isLoadStatusIgnored() {
        return this.getSingleOption("-loadStatusIgnore", null) != null;
    }
}

