/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.invoke.ConfigFileReader;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.tck.tools.file.FileToStringIterator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIDMapCreator {
    private static void add(Map<String, List<String>> map, String key, String value) {
        List<String> list = map.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            map.put(key, list);
        }
        if (!list.contains(value)) {
            list.add(value);
        }
    }

    public static void processDir(PrintWriter out, Map<String, List<String>> map, File dir) {
        String basePath = dir.getAbsolutePath() + File.separatorChar;
        for (String relPath : FileToStringIterator.traverseFiles(dir)) {
            AIDMapCreator.process(out, map, new File(basePath + relPath), relPath);
        }
    }

    public static void process(PrintWriter out, Map<String, List<String>> map, File file, String relPath) {
        if (!relPath.endsWith(".cfg")) {
            return;
        }
        ConfigFileReader reader = new ConfigFileReader(out, out);
        try {
            reader.read(file.getAbsolutePath());
            Enumeration e = reader.getPackages();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                AppletID aid = reader.getPackageAID(name);
                AIDMapCreator.add(map, String.valueOf(aid), relPath);
                for (AppletProperties appl : reader.getApplets(name)) {
                    AIDMapCreator.add(map, String.valueOf(appl.getAID()), relPath);
                }
            }
        }
        catch (IOException ex) {
            System.out.println("ERROR processing:" + relPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String[] stringArray;
        if (args.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "/home/ms106086/shared/JC-BVT_10/tests/api/java_io";
        } else {
            stringArray = args;
        }
        args = stringArray;
        TreeMap<String, List<String>> map = new TreeMap<String, List<String>>();
        PrintWriter out = new PrintWriter(new OutputStreamWriter(new OutputStream(){

            public void write(int b) throws IOException {
            }
        }));
        try {
            for (String arg : args) {
                File current = new File(arg);
                if (current.isDirectory()) {
                    AIDMapCreator.processDir(out, map, current);
                    continue;
                }
                AIDMapCreator.process(out, map, current, arg);
            }
        }
        finally {
            out.flush();
        }
        for (String aid : map.keySet()) {
            System.out.println(aid + "=" + map.get(aid));
        }
    }
}

