/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.jcwde.Globals;
import com.sun.javacard.jcwde.SimulationException;
import java.util.Vector;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;

public class SimSystem {
    private static byte transDepth;
    private static Vector clearOnResetTransientObjs;
    private static Vector clearOnDeselectTransientObjs;

    public static byte isTransient(Object object) throws SystemException {
        if (object != null) {
            if (clearOnResetTransientObjs.contains(object)) {
                return 1;
            }
            if (clearOnDeselectTransientObjs.contains(object)) {
                return 2;
            }
        }
        return 0;
    }

    private static void addTransientArray(Object object, byte by) throws SystemException {
        block8: {
            int n;
            block10: {
                block9: {
                    if (object == null) break block8;
                    if (!clearOnResetTransientObjs.contains(object)) break block9;
                    n = 1;
                    break block10;
                }
                if (!clearOnDeselectTransientObjs.contains(object)) break block8;
                n = 2;
            }
            if (n != 0) {
                SystemException.throwIt((short)3);
            }
        }
        Vector vector = null;
        switch (by) {
            case 1: {
                vector = clearOnResetTransientObjs;
                break;
            }
            case 2: {
                vector = clearOnDeselectTransientObjs;
                break;
            }
            default: {
                SystemException.throwIt((short)1);
            }
        }
        vector.addElement(object);
    }

    public static void clearTransientObjs(byte by) {
        Vector vector = null;
        switch (by) {
            case 1: {
                SimSystem.clearTransientObjs((byte)2);
                vector = clearOnResetTransientObjs;
                break;
            }
            case 2: {
                vector = clearOnDeselectTransientObjs;
                break;
            }
            default: {
                SystemException.throwIt((short)1);
            }
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            int n2;
            Object[] objectArray;
            Object e = vector.elementAt(n);
            if (e instanceof boolean[]) {
                objectArray = (boolean[])e;
                n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    objectArray[n2] = false;
                    --n2;
                }
            } else if (e instanceof byte[]) {
                objectArray = (byte[])e;
                n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    objectArray[n2] = false;
                    --n2;
                }
            } else if (e instanceof short[]) {
                objectArray = (short[])e;
                n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    objectArray[n2] = false;
                    --n2;
                }
            } else if (e instanceof Object[]) {
                objectArray = (Object[])e;
                n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    objectArray[n2] = null;
                    --n2;
                }
            } else {
                System.err.println(Globals._messages.getString("ClearTrans"));
                throw new SimulationException();
            }
            --n;
        }
    }

    public static boolean[] makeTransientBooleanArray(short s, byte by) throws SystemException {
        boolean[] blArray = new boolean[s];
        SimSystem.addTransientArray(blArray, by);
        return blArray;
    }

    public static byte[] makeTransientByteArray(short s, byte by) throws SystemException {
        byte[] byArray = new byte[s];
        SimSystem.addTransientArray(byArray, by);
        return byArray;
    }

    public static short[] makeTransientShortArray(short s, byte by) throws SystemException {
        short[] sArray = new short[s];
        SimSystem.addTransientArray(sArray, by);
        return sArray;
    }

    public static Object[] makeTransientObjectArray(short s, byte by) throws SystemException {
        Object[] objectArray = new Object[s];
        SimSystem.addTransientArray(objectArray, by);
        return objectArray;
    }

    public static void beginTransaction() throws TransactionException {
        if (transDepth != 0) {
            TransactionException.throwIt((short)1);
        }
        transDepth = 1;
    }

    public static void abortTransaction() throws TransactionException {
        if (transDepth == 0) {
            TransactionException.throwIt((short)2);
        }
        transDepth = 0;
    }

    public static void commitTransaction() throws TransactionException {
        if (transDepth == 0) {
            TransactionException.throwIt((short)2);
        }
        transDepth = 0;
    }

    public static byte getTransactionDepth() {
        return transDepth;
    }

    public static short getUnusedCommitCapacity() {
        return Short.MAX_VALUE;
    }

    public static short getMaxCommitCapacity() {
        return Short.MAX_VALUE;
    }

    static {
        clearOnResetTransientObjs = new Vector(0, 5);
        clearOnDeselectTransientObjs = new Vector(0, 5);
    }
}

